/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanCreator;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanSubscriber;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.VarHolder;

public abstract class AopFactoryBase {
    protected final Map<Class<?>, BeanWrap> beanWraps = new ConcurrentHashMap();
    protected final Map<String, BeanWrap> beans = new ConcurrentHashMap<String, BeanWrap>();
    protected final Map<Class<?>, Class<?>> clzMapping = new ConcurrentHashMap();
    protected final Map<Class<?>, BeanCreator<?>> beanCreators = new HashMap();
    protected final Map<Class<?>, BeanInjector<?>> beanInjectors = new HashMap();
    protected final Set<Runnable> loadedEvent = new LinkedHashSet<Runnable>();
    protected final Set<BeanSubscriber> subSet = new LinkedHashSet<BeanSubscriber>();

    public <T extends Annotation> void beanCreatorAdd(Class<T> anno, BeanCreator<T> creater) {
        this.beanCreators.put(anno, creater);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> anno, BeanInjector<T> injector) {
        this.beanInjectors.put(anno, injector);
    }

    public void beanSubscribe(Object key, Consumer<BeanWrap> callback) {
        if (key != null) {
            this.subSet.add(new BeanSubscriber(key, callback));
        }
    }

    public void beanNotice(Object key, BeanWrap wrap) {
        this.subSet.forEach(s1 -> {
            if (s1.key.equals(key)) {
                s1.callback.accept(wrap);
            }
        });
    }

    public void putWrap(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public void putWrap(Class<?> key, BeanWrap wrap) {
        if (key != null && !this.beanWraps.containsKey(key)) {
            this.beanWraps.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap getWrap(Object key) {
        if (key instanceof String) {
            return this.beans.get(key);
        }
        if (key instanceof Class) {
            return this.beanWraps.get(key);
        }
        return null;
    }

    protected void tryBeanCreate(Class<?> clz) {
        Annotation[] annS = clz.getDeclaredAnnotations();
        if (annS.length > 0) {
            try {
                for (Annotation a : annS) {
                    BeanCreator<?> bc = this.beanCreators.get(a.annotationType());
                    if (bc == null) continue;
                    this.tryCreateBeanByAnno(clz, a, bc);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void tryBeanInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector<?> bi = this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.handler(varH, a);
        }
    }

    protected <T extends Annotation> void tryCreateBeanByAnno(Class<?> clz, T anno, BeanCreator<T> loader) {
        try {
            BeanWrap wrap = Aop.wrapAndPut(clz);
            loader.handler(clz, wrap, anno);
            this.beanNotice(clz, wrap);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }
}

