/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class XClassLoader
extends URLClassLoader {
    private static XClassLoader _global = new XClassLoader();
    private Map<URL, JarURLConnection> cachedMap = new HashMap<URL, JarURLConnection>();

    public static XClassLoader global() {
        return _global;
    }

    protected XClassLoader() {
        super(new URL[0], ClassLoader.getSystemClassLoader());
    }

    public void loadJar(URL file) {
        try {
            URLConnection uc = file.openConnection();
            if (uc instanceof JarURLConnection) {
                uc.setUseCaches(true);
                ((JarURLConnection)uc).getManifest();
                this.cachedMap.put(file, (JarURLConnection)uc);
            }
        }
        catch (Throwable ex) {
            System.err.println("Failed to cache plugin JAR file: " + file.toExternalForm());
        }
        this.addURL(file);
    }

    public void unloadJar(URL file) {
        JarURLConnection jarURL = this.cachedMap.get(file);
        if (jarURL == null) {
            return;
        }
        try {
            jarURL.getJarFile().close();
            jarURL = null;
            this.cachedMap.remove(file);
            System.gc();
        }
        catch (Throwable ex) {
            System.err.println("Failed to unload JAR file\n" + ex);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return super.loadClass(name);
    }

    public static void bindingThread() {
        Thread.currentThread().setContextClassLoader(XClassLoader.global());
    }
}

