/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.noear.solon.XProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.core.Aop;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XRender;
import org.noear.solon.core.XRouterHandler;
import org.noear.solon.ext.Act1;
import org.noear.solon.ext.Act2;

public class XApp
implements XHandler {
    private static XApp _global;
    private final Set<Act2<String, Object>> _onSharedAdd_event = new HashSet<Act2<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private Set<Runnable> _stopEvent = new LinkedHashSet<Runnable>();
    private XRender _render = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    private final XRouter<XHandler> _router;
    private final int _port;
    private final XProperties _prop;
    private static final ThreadLocal<XContext> _threadLocal;
    private XHandler _handler = null;
    private Act2<XContext, Throwable> _onExceptionEvent;

    public static XApp global() {
        return _global;
    }

    public static XApp start(Class<?> source, String[] args) {
        return XApp.start(source, args, null);
    }

    public static XApp start(Class<?> source, String[] args, Act1<XApp> builder) {
        XMap argx = XMap.from(args);
        return XApp.start(source, argx, builder);
    }

    public static XApp start(Class<?> source, XMap argx, Act1<XApp> builder) {
        if (_global != null) {
            return _global;
        }
        long time_start = System.currentTimeMillis();
        System.out.println("solon.boot:: start begin");
        if (argx.containsKey("extend")) {
            ExtendLoader.load((String)argx.get("extend"), argx);
        }
        _global = new XApp(argx);
        if (builder != null) {
            builder.run(_global);
        }
        for (String p : _global.prop().plugs()) {
            XPlugin p1 = (XPlugin)XUtil.newClass(p);
            if (p1 == null) continue;
            _global.plug(p1);
        }
        if (source != null) {
            _global.loadBean(source);
        }
        long time_end = System.currentTimeMillis();
        System.out.println("solon.boot:: start end @" + (time_end - time_start) + "ms");
        return _global;
    }

    public static void stop() {
        if (_global == null) {
            return;
        }
        XApp._global._stopEvent.forEach(f -> f.run());
    }

    public void loadBean(Class<?> source) {
        Aop.beanLoad(source);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.run(key, obj));
    }

    public <T> T sharedGet(String key) {
        return (T)this._shared.get(key);
    }

    public <T> void sharedGet(String key, Act1<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.run(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.run(v);
                }
            });
        }
    }

    public void onSharedAdd(Act2<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public XRouter<XHandler> router() {
        return this._router;
    }

    protected XApp(XMap args) {
        this._prop = new XProperties().load(args);
        this._port = this._prop.serverPort();
        this._router = new XRouter();
        this._handler = new XRouterHandler(this._router);
    }

    public void onStop(Runnable event) {
        this._stopEvent.add(event);
    }

    public int port() {
        return this._port;
    }

    public XProperties prop() {
        return this._prop;
    }

    public XRender render() {
        return this._render;
    }

    public void render(Object obj, XContext ctx) throws Exception {
        this.render().render(obj, ctx);
    }

    public void renderSet(XRender render) {
        this._render = render;
    }

    public void plug(XPlugin plugin) {
        plugin.start(this);
    }

    public void before(String expr, String method, XHandler handler) {
        this._router.add(expr, 0, method, handler);
    }

    public void after(String expr, String method, XHandler handler) {
        this._router.add(expr, 2, method, handler);
    }

    public void add(String expr, String method, XHandler handler) {
        this._router.add(expr, 1, method, handler);
    }

    public void all(String path, XHandler handler) {
        this.add(path, "", handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, "GET", handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, "POST", handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, "PUT", handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, "DELETE", handler);
    }

    public static XContext currentContext() {
        return _threadLocal.get();
    }

    public XHandler handlerGet() {
        return this._handler;
    }

    public void handlerSet(XHandler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(XContext context) throws Exception {
        try {
            _threadLocal.set(context);
            this._handler.handle(context);
        }
        catch (Throwable ex) {
            if (this._onExceptionEvent != null) {
                this._onExceptionEvent.run(context, ex);
            }
        }
        finally {
            _threadLocal.remove();
        }
    }

    public XApp onException(Act2<XContext, Throwable> event) {
        this._onExceptionEvent = event;
        return this;
    }

    static {
        _threadLocal = new ThreadLocal();
    }
}

