/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.noear.solon.XUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XMethod;

public class XRouter<T> {
    private final List<XListener<T>> _list = new ArrayList<XListener<T>>();

    public void add(String path, T handler) {
        this.add(path, 1, "", handler);
    }

    public void add(String path, int type, String method, T handler) {
        this._list.add(new XListener<T>(XUtil.expCompile(path), type, method, handler));
    }

    public void clear() {
        this._list.clear();
    }

    public T matchOne(XContext context, int type) {
        String path = context.path();
        String method = context.method();
        for (XListener<T> l : this._list) {
            if (!l.matches(type, method, path)) continue;
            return l.h;
        }
        return null;
    }

    public List<T> matchAll(XContext context, int type) {
        String path = context.path();
        String method = context.method();
        return this._list.stream().filter(l -> l.matches(type, method, path)).map(l -> l.h).collect(Collectors.toList());
    }

    class XListener<T> {
        private int t;
        private Pattern r;
        private String m;
        protected T h;

        public XListener(String r, int t, String m, T h) {
            this.r = Pattern.compile(r, 2);
            this.t = t;
            this.m = m;
            this.h = h;
        }

        protected boolean matches(int t, String m, String p) {
            if (this.t == t && ("".equals(this.m) ? XMethod.isAll(m) : m.equals(this.m))) {
                return this.r.matcher(p).find();
            }
            return false;
        }
    }
}

