package org.noear.solon.core;

/**
 * 事务策略
 *
 *
 * 加入：指加入一个事务组；不会主动提交事务；
 *      父回滚子必回滚；子回滚父可不回滚；
 *
 * 并入：指成为当前事务的一部分；
 *      父回滚子必回滚；父子一体；
 *
 * 嵌套：指事务独立存在；会主动提交事务；回滚隔离；
 *      父回滚子不回滚；子回滚父可不回滚；
 *
 * 挂起：保存线程状态中的事务；然后移除线程状态；等执行完后，将保存的事务放回线程状态；
 *
 *
 * */
public enum TranPolicy {
    /**
     * 支持当前事务，如果没有则创建一个新的（需要入栈）
     */
    required(1),

    /**
     * 新建一个事务，同时将当前事务挂起（需要入栈）
     */
    requires_new(2),

    /**
     * 如果当前有事务，则在当前事务内部嵌套一个事务；否则新建事务（需要入栈）
     * */
    nested(3),

    /**
     * 支持当前事务，如果没有事务则报错
     * */
    mandatory(4),

    /**
     * 支持当前事务，如果没有则不使用事务
     */
    supports(5),

    /**
     * 以无事务的方式执行，如果当前有事务则将其挂起
     */
    not_supported(6),

    /**
     * 以无事务的方式执行，如果当前有事务则报错
     */
    never(7);


    public final int code;

    TranPolicy(int code) {
        this.code = code;
    }
}
