/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMethod;

public class XRouter {
    private final XListenerList[] _list = new XListenerList[]{new XListenerList(), new XListenerList(), new XListenerList(), new XListenerList(), new XListenerList(), new XListenerList()};

    public void add(String path, XHandler handler) {
        this.add(path, 1, XMethod.HTTP, handler);
    }

    public void add(String path, int endpoint, XMethod method, XHandler handler) {
        this.add(path, endpoint, method, 0, handler);
    }

    public void add(String path, int endpoint, XMethod method, int index, XHandler handler) {
        XListener xl = new XListener(path, method, index, handler);
        if (endpoint != 1 && "@@".equals(path)) {
            XListenerList tmp = new XListenerList(this._list[endpoint += 3]);
            tmp.add(xl);
            tmp.sort(Comparator.comparing(l -> l.index));
            this._list[endpoint] = tmp;
        } else {
            this._list[endpoint].add(xl);
        }
    }

    public void clear() {
        this._list[0].clear();
        this._list[1].clear();
        this._list[2].clear();
        this._list[3].clear();
        this._list[4].clear();
        this._list[5].clear();
    }

    public XHandler matchOne(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        for (XListener l : this._list[endpoint]) {
            if (!l.matches(method, path)) continue;
            return l.handler;
        }
        return null;
    }

    public List<XHandler> matchAll(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this._list[endpoint].stream().filter(l -> l.matches(method, path)).sorted(Comparator.comparingInt(l -> l.index)).map(l -> l.handler).collect(Collectors.toList());
    }

    public List<XListener> atBefore() {
        return Collections.unmodifiableList(this._list[3]);
    }

    public List<XListener> atAfter() {
        return Collections.unmodifiableList(this._list[5]);
    }

    public static class XListenerList
    extends ArrayList<XListener> {
        public XListenerList() {
        }

        public XListenerList(Collection<XListener> coll) {
            super(coll);
        }
    }
}

