package org.noear.solon.annotation;

import org.noear.solon.core.TranIsolation;
import org.noear.solon.core.TranPolicy;

import java.lang.annotation.*;

/**
 *
 * @author noear
 * @since 1.0.20
 * */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface XTran {
    /**
     * 事务传导策略
     * */
    TranPolicy policy() default TranPolicy.required;

    /*
    * 事务隔离等级
    * */
    TranIsolation isolation() default TranIsolation.unspecified;

    /**
     * 只读事务
     * */
    boolean readOnly() default false;
}
