/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XScaner;
import org.noear.solon.ext.Act2;

public final class XProperties
extends Properties {
    public static final String server_port = "server.port";
    private XMap _args;
    private List<XPluginEntity> _plugs = new ArrayList<XPluginEntity>();
    private Set<Act2<String, String>> _changeEvent = new HashSet<Act2<String, String>>();

    public XProperties load(XMap args) {
        this._args = args;
        this.do_loadFile();
        this._args.forEach((? super K k, ? super V v) -> {
            if (k.indexOf(".") >= 0) {
                this.setProperty((String)k, (String)v);
            }
        });
        return this;
    }

    public XProperties load(URL url) {
        Properties prop;
        if (url != null && (prop = XUtil.getProperties(url)) != null) {
            this.putAll((Map<?, ?>)prop);
        }
        return this;
    }

    protected void plugsScan() {
        XScaner.scan("solonplugin", n -> n.endsWith(".properties") || n.endsWith(".yml")).stream().map(k -> XUtil.getResource(k)).forEach((? super T url) -> this.do_loadPlug((URL)url));
        if (this._plugs != null) {
            this._plugs.sort(Comparator.comparingInt(p1 -> p1.priority));
        }
    }

    private void do_loadFile() {
        this.load(XUtil.getResource("application.properties"));
        this.load(XUtil.getResource("application.yml"));
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            if (key.startsWith("solon.") || key.indexOf("server.") >= 0) {
                this.setProperty(key, String.valueOf(v));
            }
        }));
    }

    private void do_loadPlug(URL url) {
        try {
            XProperties p = new XProperties().load(url);
            String temp = p.get("solon.plugin");
            if (!XUtil.isEmpty(temp)) {
                XPluginEntity ent = new XPluginEntity();
                ent.className = temp;
                ent.priority = -p.getInt("solon.plugin.priority", 0);
                this._plugs.add(ent);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void onChange(Act2<String, String> event) {
        this._changeEvent.add(event);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        Object obj = super.setProperty(key, value);
        this._changeEvent.forEach((? super T event) -> event.run(key, value));
        return obj;
    }

    public XMap argx() {
        return this._args;
    }

    public List<XPluginEntity> plugs() {
        return this._plugs;
    }

    public String get(String key) {
        return this.getProperty(key);
    }

    public String get(String key, String def) {
        return this.getProperty(key, def);
    }

    public int getInt(String key, int def) {
        String temp = this.get(key);
        if (XUtil.isEmpty(temp)) {
            return def;
        }
        return Integer.parseInt(temp);
    }

    public long getLong(String key, long def) {
        String temp = this.get(key);
        if (XUtil.isEmpty(temp)) {
            return def;
        }
        return Long.parseLong(temp);
    }

    public boolean getBool(String key, boolean def) {
        String temp = this.get(key);
        if (XUtil.isEmpty(temp)) {
            return def;
        }
        return Boolean.parseBoolean(temp);
    }

    public Object getRaw(String key) {
        return super.get(key);
    }

    public Properties getProp(String key) {
        Properties prop = new Properties();
        String key2 = key + ".";
        int idx2 = key2.length();
        String keyStr = null;
        for (Map.Entry<Object, Object> kv : this.entrySet()) {
            keyStr = kv.getKey().toString();
            if (!keyStr.startsWith(key2)) continue;
            prop.put(keyStr.substring(idx2), kv.getValue());
        }
        return prop;
    }

    public XMap getXmap(String key) {
        XMap map = new XMap();
        String key2 = key + ".";
        int idx2 = key2.length();
        String keyStr = null;
        for (Map.Entry<Object, Object> kv : this.entrySet()) {
            keyStr = kv.getKey().toString();
            if (!keyStr.startsWith(key2)) continue;
            map.put(keyStr.substring(idx2), kv.getValue().toString());
        }
        return map;
    }

    public int serverPort() {
        return this.getInt(server_port, 8080);
    }

    public boolean isDebugMode() {
        return this.argx().getInt("debug") == 1;
    }
}

