/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.noear.solon.XApp;
import org.noear.solon.annotation.XNote;
import org.noear.solon.core.CacheService;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XActionExecutorDefault;
import org.noear.solon.core.XCacheExecutor;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRender;
import org.noear.solon.core.XRenderManager;
import org.noear.solon.core.XSessionState;
import org.noear.solon.core.XTranExecutor;
import org.noear.solon.core.XUpstreamFactory;

public class XBridge {
    private static XSessionState _sessionState = new XSessionStateDefault();
    private static boolean _sessionStateUpdated;
    private static XUpstreamFactory _upstreamFactory;
    private static XActionExecutor _actionExecutorDef;
    private static Set<XActionExecutor> _actionExecutors;
    private static XTranExecutor _tranExecutor;
    private static Map<String, CacheService> cacheServiceMap;
    private static XCacheExecutor _cacheExecutor;

    @XNote(value="\u8bbe\u7f6eSession\u72b6\u6001\u7ba1\u7406\u5668")
    public static void sessionStateSet(XSessionState ss) {
        if (ss != null) {
            _sessionState = ss;
            if (!_sessionStateUpdated) {
                _sessionStateUpdated = true;
                XApp.global().before("**", XMethod.HTTP, c -> _sessionState.sessionRefresh());
            }
        }
    }

    @XNote(value="\u83b7\u53d6Session\u72b6\u6001\u7ba1\u7406\u5668")
    public static XSessionState sessionState() {
        return _sessionState;
    }

    @XNote(value="\u83b7\u53d6\u8d1f\u8f7d\u5de5\u5382")
    public static XUpstreamFactory upstreamFactory() {
        return _upstreamFactory;
    }

    @XNote(value="\u8bbe\u7f6e\u8d1f\u8f7d\u5de5\u5382")
    public static void upstreamFactorySet(XUpstreamFactory uf) {
        if (uf != null) {
            _upstreamFactory = uf;
        }
    }

    @XNote(value="\u83b7\u53d6\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static XActionExecutor actionExecutorDef() {
        return _actionExecutorDef;
    }

    @XNote(value="\u8bbe\u7f6e\u9ed8\u8ba4\u7684Action\u6267\u884c\u5668")
    public static void actionExecutorDefSet(XActionExecutor ae) {
        if (ae != null) {
            _actionExecutorDef = ae;
        }
    }

    @XNote(value="\u83b7\u53d6\u6240\u6709Action\u6267\u884c\u5668")
    public static Set<XActionExecutor> actionExecutors() {
        return Collections.unmodifiableSet(_actionExecutors);
    }

    @XNote(value="\u6dfb\u52a0Action\u6267\u884c\u5668")
    public static void actionExecutorAdd(XActionExecutor e) {
        if (e != null) {
            _actionExecutors.add(e);
        }
    }

    @XNote(value="\u6ce8\u518c\u6e32\u67d3\u5668")
    public static void renderRegister(XRender render) {
        if (render != null) {
            XRenderManager.register(render);
        }
    }

    @XNote(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, XRender render) {
        if (suffix != null && render != null) {
            XRenderManager.mapping(suffix, render);
        }
    }

    @XNote(value="\u5370\u5c04\u6e32\u67d3\u5173\u7cfb")
    public static void renderMapping(String suffix, String className) {
        if (suffix != null && className != null) {
            XRenderManager.mapping(suffix, className);
        }
    }

    @XNote(value="\u83b7\u53d6\u4e8b\u52a1\u6267\u884c\u5668")
    public static XTranExecutor tranExecutor() {
        return _tranExecutor;
    }

    @XNote(value="\u8bbe\u7f6e\u4e8b\u52a1\u6267\u884c\u5668")
    public static void tranExecutorSet(XTranExecutor te) {
        if (te != null) {
            _tranExecutor = te;
        }
    }

    @XNote(value="\u7f13\u5b58\u670d\u52a1\u96c6\u5408\uff1b\u53ea\u8bfb")
    public static Map<String, CacheService> cacheServiceMap() {
        return Collections.unmodifiableMap(cacheServiceMap);
    }

    @XNote(value="\u6dfb\u52a0\u7f13\u5b58\u670d\u52a1")
    public static void cacheServiceAdd(String name, CacheService cs) {
        cacheServiceMap.put(name, cs);
    }

    @XNote(value="\u6dfb\u52a0\u7f13\u5b58\u670d\u52a1")
    public static void cacheServiceAddIfAbsent(String name, CacheService cs) {
        cacheServiceMap.putIfAbsent(name, cs);
    }

    @XNote(value="\u83b7\u53d6\u7f13\u5b58\u670d\u52a1")
    public static CacheService cacheServiceGet(String name) {
        return cacheServiceMap.get(name);
    }

    @XNote(value="\u83b7\u53d6\u7f13\u5b58\u6267\u884c\u5668")
    public static XCacheExecutor cacheExecutor() {
        if (_cacheExecutor == null) {
            throw new RuntimeException("XBridge: The cache actuator is not initialized");
        }
        return _cacheExecutor;
    }

    @XNote(value="\u8bbe\u7f6e\u7f13\u5b58\u6267\u884c\u5668")
    public static void cacheExecutorSet(XCacheExecutor ce) {
        if (ce != null) {
            _cacheExecutor = ce;
        }
    }

    static {
        _upstreamFactory = service -> {
            throw new RuntimeException("XBridge: The upstream factory is not initialized");
        };
        _actionExecutorDef = new XActionExecutorDefault();
        _actionExecutors = new HashSet<XActionExecutor>();
        _tranExecutor = (anno, runnable) -> runnable.run();
        cacheServiceMap = new HashMap<String, CacheService>();
    }

    static class XSessionStateDefault
    implements XSessionState {
        XSessionStateDefault() {
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public Object sessionGet(String key) {
            return null;
        }

        @Override
        public void sessionSet(String key, Object val) {
        }
    }
}

