/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class SocketMessage {
    public String key;
    public String resourceDescriptor;
    public byte[] content;
    public Charset charset = StandardCharsets.UTF_8;

    protected SocketMessage() {
    }

    public static SocketMessage wrap(String resourceDescriptor, byte[] bytes) {
        return SocketMessage.wrap(UUID.randomUUID().toString(), resourceDescriptor, bytes);
    }

    public static SocketMessage wrap(String key, String resourceDescriptor, byte[] bytes) {
        SocketMessage msg = new SocketMessage();
        msg.key = key;
        msg.resourceDescriptor = resourceDescriptor;
        msg.content = bytes;
        return msg;
    }

    public static SocketMessage decode(ByteBuffer buffer) {
        ByteBuffer sb = ByteBuffer.allocate(Math.min(256, buffer.limit()));
        int len0 = buffer.getInt();
        String key = SocketMessage.readStr(buffer, sb);
        if (key == null) {
            return null;
        }
        String uri = SocketMessage.readStr(buffer, sb);
        if (uri == null) {
            return null;
        }
        int len = len0 - buffer.position();
        byte[] bytes = new byte[len];
        buffer.get(bytes, 0, len);
        SocketMessage msg = new SocketMessage();
        msg.key = key;
        msg.resourceDescriptor = uri;
        msg.content = bytes;
        return msg;
    }

    public ByteBuffer encode() {
        byte[] keyB = this.key.getBytes(this.charset);
        byte[] rdB = this.resourceDescriptor.getBytes(this.charset);
        int len = keyB.length + rdB.length + this.content.length + 4 + 4;
        ByteBuffer buffer = ByteBuffer.allocate(len);
        buffer.putInt(len);
        buffer.put(keyB);
        buffer.putChar('\n');
        buffer.put(rdB);
        buffer.putChar('\n');
        buffer.put(this.content);
        buffer.flip();
        return buffer;
    }

    public String toString() {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, this.charset);
    }

    private static String readStr(ByteBuffer buffer, ByteBuffer sb) {
        byte c;
        sb.position(0);
        while ((c = buffer.get()) != 10) {
            if (c > 32 || c < 0) {
                sb.put(c);
            }
            if (256 >= sb.position()) continue;
            return null;
        }
        sb.flip();
        if (sb.limit() < 1) {
            return null;
        }
        return new String(sb.array(), 0, sb.limit());
    }
}

