/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodWrap {
    private static Map<Method, MethodWrap> _cache = new ConcurrentHashMap<Method, MethodWrap>();
    private final Method method;
    private final Parameter[] parameters;

    public static MethodWrap get(Method method) {
        MethodWrap l;
        MethodWrap mw = _cache.get(method);
        if (mw == null && (l = _cache.putIfAbsent(method, mw = new MethodWrap(method))) != null) {
            mw = l;
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = m.getParameters();
    }

    public String getName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public Object invoke(Object obj, Object ... args) throws Exception {
        if (this.parameters.length == 0) {
            return this.method.invoke(obj, new Object[0]);
        }
        return this.method.invoke(obj, args);
    }
}

