/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.XUtil;
import org.noear.solon.core.ModelAndView;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.PrintUtil;

public class XRenderManager
implements XRender {
    private static final Map<String, XRender> _mapping = new HashMap<String, XRender>();
    private static final Map<String, XRender> _lib = new HashMap<String, XRender>();
    private static XRender _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    public static XRender global = new XRenderManager();

    private XRenderManager() {
    }

    protected static void register(XRender render) {
        _def = render;
        _lib.put(render.getClass().getSimpleName(), render);
        _lib.put(render.getClass().getName(), render);
        PrintUtil.blueln("solon:: view load:" + render.getClass().getSimpleName());
        PrintUtil.blueln("solon:: view load:" + render.getClass().getName());
    }

    protected static void mapping(String suffix, XRender render) {
        _mapping.put(suffix, render);
        PrintUtil.blueln("solon:: view mapping: " + suffix + "=" + render.getClass().getSimpleName());
    }

    protected static void mapping(String suffix, String className) {
        XRender render = _lib.get(className);
        if (render == null) {
            PrintUtil.redln("solon:: " + className + " not exists!");
            return;
        }
        _mapping.put(suffix, render);
        PrintUtil.blueln("solon:: view mapping: " + suffix + "=" + className);
    }

    @Override
    public void render(Object obj, XContext ctx) throws Throwable {
        ModelAndView mv;
        if (obj instanceof ModelAndView && !XUtil.isEmpty((mv = (ModelAndView)obj).view())) {
            String suffix;
            XRender render;
            int suffix_idx = mv.view().lastIndexOf(".");
            if (suffix_idx > 0 && (render = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                render.render(mv, ctx);
                return;
            }
            _def.render(mv, ctx);
            return;
        }
        XRender render = null;
        String mode = ctx.header("X-Serialization");
        if (XUtil.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!XUtil.isEmpty(mode) && (render = _mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null && ctx.remoting()) {
            render = _mapping.get("@type_json");
        }
        if (render == null) {
            render = _mapping.get("@json");
        }
        if (render != null) {
            render.render(obj, ctx);
        } else {
            _def.render(obj, ctx);
        }
    }
}

