/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XRouteTable;
import org.noear.solon.core.XSession;

public class XRouter {
    private final XRouteTable<XHandler>[] routesH = new XRouteTable[6];
    private final List<XHandler>[] routesHC;
    private final XRouteTable<XListener> routesL;

    public XRouter() {
        this.routesH[0] = new XRouteTable();
        this.routesH[1] = new XRouteTable();
        this.routesH[2] = new XRouteTable();
        this.routesH[3] = new XRouteTable();
        this.routesH[4] = new XRouteTable();
        this.routesH[5] = new XRouteTable();
        this.routesHC = new List[3];
        this.routesHC[0] = new ArrayList<XHandler>();
        this.routesHC[1] = new ArrayList<XHandler>();
        this.routesHC[2] = new ArrayList<XHandler>();
        this.routesL = new XRouteTable();
    }

    public void add(String path, XHandler handler) {
        this.add(path, 1, XMethod.HTTP, handler);
    }

    public void add(String path, int endpoint, XMethod method, XHandler handler) {
        this.add(path, endpoint, method, 0, handler);
    }

    public void add(String path, int endpoint, XMethod method, int index, XHandler handler) {
        XRouteTable.Route<XHandler> xl = new XRouteTable.Route<XHandler>(path, method, index, handler);
        if (endpoint != 1 && "@@".equals(path)) {
            XRouteTable<XHandler> tmp = this.routesH[endpoint + 3];
            tmp.add(xl);
            tmp.sort(Comparator.comparing(l -> l.index));
            this.routesHC[endpoint] = tmp.stream().map(r -> (XHandler)r.target).collect(Collectors.toList());
        } else {
            this.routesH[endpoint].add(xl);
        }
    }

    public void add(String path, XListener listener) {
        this.add(path, XMethod.ALL, listener);
    }

    public void add(String path, XMethod method, XListener listener) {
        this.add(path, method, 0, listener);
    }

    public void add(String path, XMethod method, int index, XListener listener) {
        this.routesL.add(new XRouteTable.Route<XListener>(path, method, index, listener));
    }

    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
        this.routesH[3].clear();
        this.routesH[4].clear();
        this.routesH[5].clear();
    }

    public XHandler matchOne(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this.routesH[endpoint].matchOne(path, method);
    }

    public List<XHandler> matchAll(XContext context, int endpoint) {
        String path = context.path();
        XMethod method = XMethod.valueOf(context.method());
        return this.routesH[endpoint].matchAll(path, method);
    }

    public XListener matchOne(XSession session) {
        String path = session.path();
        return this.routesL.matchOne(path, session.method());
    }

    public List<XHandler> atBefore() {
        return Collections.unmodifiableList(this.routesHC[0]);
    }

    public List<XHandler> atAfter() {
        return Collections.unmodifiableList(this.routesHC[2]);
    }
}

