/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ClassWrap;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XProperties;
import org.noear.solon.ext.ConvertUtil;

public class BeanContainer {
    protected final Map<Class<?>, BeanWrap> beanWraps = new ConcurrentHashMap();
    protected final Map<String, BeanWrap> beans = new ConcurrentHashMap<String, BeanWrap>();
    protected final Map<Class<?>, Class<?>> clzMapping = new ConcurrentHashMap();
    protected final Map<Class<?>, BeanBuilder<?>> beanBuilders = new HashMap();
    protected final Map<Class<?>, BeanInjector<?>> beanInjectors = new HashMap();
    protected final Set<SubscriberEntity> beanSubscribers = new LinkedHashSet<SubscriberEntity>();

    public <T extends Annotation> void beanBuilderAdd(Class<T> anno, BeanBuilder<T> creater) {
        this.beanBuilders.put(anno, creater);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> anno, BeanInjector<T> injector) {
        this.beanInjectors.put(anno, injector);
    }

    public void beanSubscribe(Object key, Consumer<BeanWrap> callback) {
        if (key != null) {
            this.beanSubscribers.add(new SubscriberEntity(key, callback));
        }
    }

    public void beanNotice(Object key, BeanWrap wrap) {
        if (wrap.raw() == null) {
            return;
        }
        new ArrayList<SubscriberEntity>(this.beanSubscribers).forEach(s1 -> {
            if (s1.key.equals(key)) {
                s1.callback.accept(wrap);
            }
        });
    }

    public void putWrap(String key, BeanWrap wrap) {
        if (!XUtil.isEmpty(key) && wrap.raw() != null && !this.beans.containsKey(key)) {
            this.beans.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public void putWrap(Class<?> key, BeanWrap wrap) {
        if (key != null && wrap.raw() != null && !this.beanWraps.containsKey(key)) {
            this.beanWraps.put(key, wrap);
            this.beanNotice(key, wrap);
        }
    }

    public BeanWrap getWrap(Object key) {
        if (key instanceof String) {
            return this.beans.get(key);
        }
        return this.beanWraps.get(key);
    }

    public void getWrapAsync(Object key, Consumer<BeanWrap> callback) {
        BeanWrap bw = this.getWrap(key);
        if (bw == null || bw.raw() == null) {
            this.beanSubscribe(key, callback);
        } else {
            callback.accept(bw);
        }
    }

    public <T> T getBean(Object key) {
        BeanWrap bw = this.getWrap(key);
        return bw == null ? null : (T)bw.get();
    }

    public BeanWrap wrap(Class<?> clz, Object bean) {
        BeanWrap wrap = this.getWrap(clz);
        if (wrap == null) {
            wrap = new BeanWrap(clz, bean);
        }
        return wrap;
    }

    public void beanRegister(BeanWrap bw, String name, boolean typed) {
        Class<?>[] list;
        if (XUtil.isNotEmpty(name)) {
            this.putWrap(name, bw);
            if (!typed) {
                return;
            }
        }
        this.putWrap(bw.clz(), bw);
        this.putWrap(bw.clz().getName(), bw);
        for (Class<?> c : list = bw.clz().getInterfaces()) {
            if (c.getName().contains("java.")) continue;
            this.clzMapping.putIfAbsent(c, bw.clz());
            this.putWrap(c, bw);
        }
    }

    public void beanInject(VarHolder varH, String name) {
        if (XUtil.isEmpty(name)) {
            this.getWrapAsync(varH.getType(), bw -> varH.setValue(bw.get()));
        } else if (name.startsWith("${classpath:")) {
            String url = name.substring(12, name.length() - 1);
            Properties val = XUtil.loadProperties(XUtil.getResource(url));
            if (val == null) {
                throw new RuntimeException(name + "  failed to load!");
            }
            if (Properties.class == varH.getType()) {
                varH.setValue(val);
            } else if (Map.class == varH.getType()) {
                HashMap val2 = new HashMap();
                val.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        val2.put((String)k, (String)v);
                    }
                }));
                varH.setValue(val2);
            } else {
                Object val2 = ClassWrap.get(varH.getType()).newBy(val::getProperty);
                varH.setValue(val2);
            }
        } else if (name.startsWith("${")) {
            name = name.substring(2, name.length() - 1);
            if (Properties.class == varH.getType()) {
                XProperties val = XApp.cfg().getProp(name);
                varH.setValue(val);
            } else if (Map.class == varH.getType()) {
                XMap val = XApp.cfg().getXmap(name);
                varH.setValue(val);
            } else {
                String val = XApp.cfg().get(name);
                if (val == null) {
                    Class<?> pt = varH.getType();
                    if (pt.getName().startsWith("java.") || pt.isArray() || pt.isPrimitive()) {
                        varH.setValue(null);
                    } else {
                        XProperties val0 = XApp.cfg().getProp(name);
                        Object val2 = ClassWrap.get(pt).newBy(val0::getProperty);
                        varH.setValue(val2);
                    }
                } else {
                    Object val2 = ConvertUtil.to(varH.getType(), val);
                    varH.setValue(val2);
                }
            }
        } else {
            this.getWrapAsync(name, bw -> varH.setValue(bw.get()));
        }
    }

    public void beanForeach(BiConsumer<String, BeanWrap> action) {
        this.beans.forEach(action);
    }

    public void beanForeach(Consumer<BeanWrap> action) {
        this.beanWraps.forEach((k, bw) -> action.accept((BeanWrap)bw));
    }

    class SubscriberEntity {
        public Object key;
        public Consumer<BeanWrap> callback;

        public SubscriberEntity(Object key, Consumer<BeanWrap> callback) {
            this.key = key;
            this.callback = callback;
        }
    }
}

