/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.annotation.XAround;
import org.noear.solon.core.Aop;
import org.noear.solon.core.MethodChain;
import org.noear.solon.core.MethodHandler;

public class MethodWrap
implements MethodChain {
    private static Map<Method, MethodWrap> _cache = new ConcurrentHashMap<Method, MethodWrap>();
    private final Method method;
    private final Parameter[] parameters;
    private final Annotation[] annotations;
    private final List<MethodChain.Entity> arounds;
    private final MethodChain invokeChain;

    public static MethodWrap get(Method method) {
        MethodWrap l;
        MethodWrap mw = _cache.get(method);
        if (mw == null && (l = _cache.putIfAbsent(method, mw = new MethodWrap(method))) != null) {
            mw = l;
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.method = m;
        this.parameters = m.getParameters();
        this.annotations = m.getAnnotations();
        this.arounds = new ArrayList<MethodChain.Entity>();
        for (Annotation anno : this.annotations) {
            if (anno instanceof XAround) {
                this.aroundAdd((XAround)anno);
                continue;
            }
            this.aroundAdd(anno.annotationType().getAnnotation(XAround.class));
        }
        if (this.arounds.size() > 0) {
            this.arounds.sort(Comparator.comparing(x -> x.index));
            MethodChain.Entity node = this.arounds.get(0);
            int len = this.arounds.size();
            for (int i = 1; i < len; ++i) {
                node.next = this.arounds.get(i);
                node = this.arounds.get(i);
            }
            node.next = this;
            this.invokeChain = this.arounds.get(0);
        } else {
            this.invokeChain = this;
        }
    }

    private void aroundAdd(XAround a) {
        if (a != null) {
            this.arounds.add(new MethodChain.Entity(this, a.index(), (MethodHandler)Aop.get(a.value())));
        }
    }

    public String getName() {
        return this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public Object doInvoke(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invoke(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        return this.invokeChain.doInvoke(obj, args);
    }
}

