/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XMapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.DataThrowable;
import org.noear.solon.core.MethodWrap;
import org.noear.solon.core.PathAnalyzer;
import org.noear.solon.core.XActionExecutor;
import org.noear.solon.core.XBridge;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerAide;
import org.noear.solon.core.XRender;
import org.noear.solon.ext.RunnableEx;

public class XAction
extends XHandlerAide
implements XHandler {
    protected final BeanWrap bw;
    protected final XHandlerAide bAide;
    protected XRender bRender;
    protected boolean bIsMain;
    protected final MethodWrap mw;
    protected String mProduces;
    private String mName;
    private boolean mRemoting;
    private PathAnalyzer _pr;
    private List<String> _pks;
    private static Pattern _pkr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public XAction(BeanWrap bw, XHandlerAide ca, boolean poi_main, Method m, XMapping mp, String path, boolean remoting, XRender render) {
        this.bw = bw;
        this.bAide = ca;
        this.mw = MethodWrap.get(m);
        this.mRemoting = remoting;
        this.bRender = render;
        this.bIsMain = poi_main;
        if (this.bRender == null && XRender.class.isAssignableFrom(bw.clz())) {
            this.bRender = (XRender)bw.raw();
        }
        if (mp != null) {
            this.mProduces = mp.produces();
            this.mName = mp.value();
        } else {
            this.mName = m.getName();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this._pks = new ArrayList<String>();
            Matcher pm = _pkr.matcher(path);
            while (pm.find()) {
                this._pks.add(pm.group(1));
            }
            if (this._pks.size() > 0) {
                this._pr = new PathAnalyzer(path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public MethodWrap method() {
        return this.mw;
    }

    public BeanWrap bean() {
        return this.bw;
    }

    @Override
    public void handle(XContext x) throws Throwable {
        this.invoke(x, null);
    }

    public void invoke(XContext x, Object obj) throws Throwable {
        x.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bw.get();
            }
            if (this.bIsMain) {
                x.attrSet("controller", obj);
                x.attrSet("action", this);
            }
            this.invoke0(x, obj);
        }
        catch (Throwable ex) {
            x.attrSet("error", ex);
            this.renderDo(ex, x);
            XEventBus.push(ex);
        }
    }

    protected void invoke0(XContext x, Object obj) throws Throwable {
        if (this.bIsMain) {
            this.handleDo(x, () -> {
                for (XHandler h : XApp.global().router().atBefore()) {
                    h.handle(x);
                }
                for (XHandler h : this.bAide.befores) {
                    h.handle(x);
                }
                for (XHandler h : this.befores) {
                    h.handle(x);
                }
            });
        }
        if (!x.getHandled()) {
            this.handleDo(x, () -> {
                Matcher pm;
                if (this._pr != null && (pm = this._pr.matcher(x.path())).find()) {
                    int len = this._pks.size();
                    for (int i = 0; i < len; ++i) {
                        x.paramSet(this._pks.get(i), pm.group(i + 1));
                    }
                }
                Object tmp = this.callDo(x, obj, this.mw);
                if (this.bIsMain) {
                    x.result = tmp;
                    if (!XUtil.isEmpty(this.mProduces)) {
                        x.contentType(this.mProduces);
                    }
                    this.renderDo(tmp, x);
                }
            });
        }
        if (this.bIsMain) {
            for (XHandler h : XApp.global().router().atAfter()) {
                h.handle(x);
            }
            for (XHandler h : this.bAide.afters) {
                h.handle(x);
            }
            for (XHandler h : this.afters) {
                h.handle(x);
            }
        }
    }

    protected void handleDo(XContext c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            c.setHandled(true);
            ex = XUtil.throwableUnwrap(ex);
            if (ex instanceof DataThrowable) {
                this.renderDo(ex, c);
            }
            c.attrSet("error", ex);
            this.renderDo(ex, c);
            XEventBus.push(ex);
        }
    }

    protected Object callDo(XContext ctx, Object obj, MethodWrap mWrap) throws Throwable {
        String ct = ctx.contentType();
        for (XActionExecutor me : XBridge.actionExecutors()) {
            if (!me.matched(ctx, ct)) continue;
            return me.execute(ctx, obj, mWrap);
        }
        return XBridge.actionExecutorDef().execute(ctx, obj, mWrap);
    }

    protected void renderDo(Object result, XContext x) throws Throwable {
        if (x.getRendered()) {
            return;
        }
        x.result = result;
        if (this.bRender == null) {
            x.setRendered(true);
            x.render(result);
        } else {
            this.bRender.render(result, x);
        }
    }
}

