/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.XAppProperties;
import org.noear.solon.XRouter;
import org.noear.solon.XUtil;
import org.noear.solon.annotation.XImport;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.XBridge;
import org.noear.solon.core.XClassLoader;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XContextUtil;
import org.noear.solon.core.XEndpoint;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XEventListener;
import org.noear.solon.core.XHandler;
import org.noear.solon.core.XHandlerLoader;
import org.noear.solon.core.XHandlerSlots;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XPlugin;
import org.noear.solon.core.XPluginEntity;
import org.noear.solon.core.XRouterHandler;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.ext.ConsumerEx;

public class XApp
implements XHandler,
XHandlerSlots {
    private static XApp global;
    private static boolean _stopped;
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private final XRouter _router;
    private final int _port;
    private final XAppProperties _prop;
    private final Class<?> _source;
    private XHandler _handler = null;
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = false;
    private boolean _enableSocket = false;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;
    private boolean _enableSessionState = true;

    public static XApp global() {
        return global;
    }

    public static XAppProperties cfg() {
        return XApp.global().prop();
    }

    public static XApp start(Class<?> source, String[] args) {
        return XApp.start(source, args, null);
    }

    public static XApp start(Class<?> source, String[] args, ConsumerEx<XApp> builder) {
        XMap argx = XMap.from(args);
        return XApp.start(source, argx, builder);
    }

    public static XApp start(Class<?> source, XMap argx, ConsumerEx<XApp> builder) {
        if (global != null) {
            return global;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> XApp.stop(false, 0L)));
        XClassLoader.bindingThread();
        long time_start = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: Start loading");
        global = new XApp(source, argx);
        ExtendLoader.load(global.prop().extend());
        global.prop().plugsScan();
        if (builder != null) {
            try {
                builder.accept(global);
            }
            catch (Throwable ex) {
                throw XUtil.throwableWrap(ex);
            }
        }
        List<XPluginEntity> plugs = global.prop().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        global.importTry();
        if (source != null) {
            Aop.context().beanScan(source);
        }
        XMap map = global.prop().getXmap("solon.view.mapping");
        map.forEach((k, v) -> XBridge.renderMapping("." + k, v));
        Aop.context().beanLoaded();
        long time_end = System.currentTimeMillis();
        PrintUtil.blueln("solon.plugin:: End loading @" + (time_end - time_start) + "ms");
        return global;
    }

    private void importTry() {
        if (this._source == null) {
            return;
        }
        for (Annotation a1 : this._source.getAnnotations()) {
            if (a1 instanceof XImport) {
                Aop.context().beanImport((XImport)a1);
                continue;
            }
            Aop.context().beanImport(a1.annotationType().getAnnotation(XImport.class));
        }
    }

    public static void stop() {
        XApp.stop(true, 0L);
    }

    public static void stop(boolean exit, long delay) {
        if (global == null) {
            return;
        }
        _stopped = true;
        XUtil.commonPool.submit(() -> {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
            global.prop().plugs().forEach(p -> p.stop());
            global = null;
            if (exit) {
                System.exit(0);
            }
            return null;
        });
    }

    public void beanScan(Class<?> source) {
        Aop.context().beanScan(source);
    }

    public void beanScan(String basePackage) {
        Aop.context().beanScan(basePackage);
    }

    public BeanWrap beanMake(Class<?> clz) {
        return Aop.context().beanMake(clz);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public XRouter router() {
        return this._router;
    }

    protected XApp(Class<?> source, XMap args) {
        this._source = source;
        this._prop = new XAppProperties().load(args);
        this._port = this._prop.serverPort();
        this._router = new XRouter();
        this._handler = new XRouterHandler(this._router);
    }

    public Class<?> source() {
        return this._source;
    }

    public int port() {
        return this._port;
    }

    public XAppProperties prop() {
        return this._prop;
    }

    public void plug(XPlugin plugin) {
        XPluginEntity p = new XPluginEntity(plugin);
        p.start();
        this.prop().plugs().add(p);
    }

    public void before(String expr, XHandler handler) {
        this.before(expr, XMethod.ALL, handler);
    }

    public void before(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, XEndpoint.before, method, handler);
    }

    @Override
    public void before(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, XEndpoint.before, method, index, handler);
    }

    public void after(String expr, XHandler handler) {
        this.after(expr, XMethod.ALL, handler);
    }

    public void after(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, XEndpoint.after, method, handler);
    }

    @Override
    public void after(String expr, XMethod method, int index, XHandler handler) {
        this._router.add(expr, XEndpoint.after, method, index, handler);
    }

    @Override
    public void add(String expr, XMethod method, XHandler handler) {
        this._router.add(expr, XEndpoint.main, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new XHandlerLoader(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new XHandlerLoader(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, XHandler handler) {
        this.add(path, XMethod.ALL, handler);
    }

    public void http(String path, XHandler handler) {
        this.add(path, XMethod.HTTP, handler);
    }

    public void get(String path, XHandler handler) {
        this.add(path, XMethod.GET, handler);
    }

    public void post(String path, XHandler handler) {
        this.add(path, XMethod.POST, handler);
    }

    public void put(String path, XHandler handler) {
        this.add(path, XMethod.PUT, handler);
    }

    public void patch(String path, XHandler handler) {
        this.add(path, XMethod.PATCH, handler);
    }

    public void delete(String path, XHandler handler) {
        this.add(path, XMethod.DELETE, handler);
    }

    public void ws(String path, XHandler handler) {
        this.add(path, XMethod.WEBSOCKET, handler);
    }

    public void ws(String path, XListener listener) {
        this._router.add(path, XMethod.WEBSOCKET, listener);
    }

    public void socket(String path, XHandler handler) {
        this.add(path, XMethod.SOCKET, handler);
    }

    public void socket(String path, XListener listener) {
        this._router.add(path, XMethod.SOCKET, listener);
    }

    public XHandler handlerGet() {
        return this._handler;
    }

    public void handlerSet(XHandler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(XContext x) throws Throwable {
        if (_stopped) {
            return;
        }
        try {
            XContextUtil.currentSet(x);
            this._handler.handle(x);
        }
        catch (Throwable ex) {
            XEventBus.push(ex);
            throw ex;
        }
        finally {
            XContextUtil.currentRemove();
        }
    }

    public void tryHandle(XContext x) {
        try {
            this.handle(x);
        }
        catch (Throwable ex) {
            ex = XUtil.throwableUnwrap(ex);
            x.statusSet(500);
            x.setHandled(true);
            x.output(XUtil.getFullStackTrace(ex));
        }
    }

    public XApp onError(XEventListener<Throwable> handler) {
        return this.onEvent(Throwable.class, handler);
    }

    public <T> XApp onEvent(Class<T> type, XEventListener<T> handler) {
        XEventBus.subscribe(type, handler);
        return this;
    }

    public boolean enableHttp() {
        return this._enableHttp;
    }

    public XApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket;
    }

    public XApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableSocket() {
        return this._enableSocket;
    }

    public XApp enableSocket(boolean enable) {
        this._enableSocket = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public XApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public XApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public XApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }

    public boolean enableSessionState() {
        return this._enableSessionState;
    }

    public XApp enableSessionState(boolean enable) {
        this._enableSessionState = enable;
        return this;
    }
}

