/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorEntity;
import org.noear.solon.lang.Nullable;

public class RouterHandler
implements Handler,
RouterInterceptor {
    private Router router;
    private final List<RouterInterceptorEntity> interceptorList;

    public RouterHandler(Router router) {
        this.bind(router);
        this.interceptorList = new ArrayList<RouterInterceptorEntity>();
        this.addInterceptor(this, Integer.MAX_VALUE);
    }

    public void addInterceptor(RouterInterceptor interceptor, int index) {
        RouterInterceptorEntity node = new RouterInterceptorEntity(index, interceptor);
        this.interceptorList.add(node);
        this.interceptorList.sort(Comparator.comparingInt(f -> f.index));
    }

    public void bind(Router router) {
        this.router = router;
    }

    protected boolean handleMain(Handler h, Context ctx) throws Throwable {
        if (h != null) {
            h.handle(ctx);
            return ctx.status() != 404;
        }
        return false;
    }

    protected void handleMultiple(Context ctx, Endpoint endpoint) throws Throwable {
        for (Handler h : this.router.matchAll(ctx, endpoint)) {
            h.handle(ctx);
        }
    }

    private void handleDo(Context x, Handler mainHandler) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        try {
            this.handleMultiple(x, Endpoint.before);
            if (!x.getHandled()) {
                x.setHandled(this.handleMain(mainHandler, x));
            }
        }
        catch (Throwable e) {
            if (x.errors == null) {
                x.errors = e;
            }
            throw e;
        }
        finally {
            this.handleMultiple(x, Endpoint.after);
        }
    }

    @Override
    public void doIntercept(Context ctx, @Nullable Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        this.handleDo(ctx, mainHandler);
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        Handler mainHandler = this.router.matchMain(x);
        if (mainHandler instanceof Action) {
            x.attrSet("action", mainHandler);
        }
        new RouterInterceptorChainImpl(this.interceptorList).doIntercept(x, mainHandler);
    }
}

