/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.wrap.FieldWrap;

public class ClassWrap {
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Method[] methods;
    private final List<FieldWrap> fieldWraps;
    private final Map<String, FieldWrap> fieldAllWrapsMap;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap l;
        ClassWrap cw = cached.get(clz);
        if (cw == null && (l = cached.putIfAbsent(clz, cw = new ClassWrap(clz))) != null) {
            cw = l;
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this._clz = clz;
        this.methods = clz.getDeclaredMethods();
        this.fieldAllWrapsMap = new ConcurrentHashMap<String, FieldWrap>();
        ClassWrap.doScanAllFields(clz, this.fieldAllWrapsMap::containsKey, this.fieldAllWrapsMap::put);
        this.fieldWraps = new ArrayList<FieldWrap>();
        for (Field f : clz.getDeclaredFields()) {
            FieldWrap fw = this.fieldAllWrapsMap.get(f.getName());
            if (fw == null) continue;
            this.fieldWraps.add(fw);
        }
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Map<String, FieldWrap> getFieldAllWraps() {
        return Collections.unmodifiableMap(this.fieldAllWrapsMap);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public <T> T newBy(Function<String, String> data) {
        return this.newBy(data, null);
    }

    public <T> T newBy(Function<String, String> data, Context ctx) {
        try {
            Object obj = this.clz().newInstance();
            this.fill(obj, data, ctx);
            return (T)obj;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void fill(Object bean, Function<String, String> data, Context ctx) {
        for (Map.Entry<String, FieldWrap> kv : this.fieldAllWrapsMap.entrySet()) {
            String key = kv.getKey();
            String val0 = data.apply(key);
            if (val0 == null) continue;
            FieldWrap fw = kv.getValue();
            Object val = ConvertUtil.to(fw.field, fw.type, key, val0, ctx);
            fw.setValue(bean, val);
        }
    }

    private static void doScanAllFields(Class<?> clz, Predicate<String> checker, BiConsumer<String, FieldWrap> consumer) {
        if (clz == null) {
            return;
        }
        for (Field f : clz.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            f.setAccessible(true);
            if (checker.test(f.getName())) continue;
            consumer.accept(f.getName(), new FieldWrap(clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            ClassWrap.doScanAllFields(sup, checker, consumer);
        }
    }
}

