/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.PrintUtil;

public class RenderManager
implements Render {
    private static final Map<String, Render> _mapping = new HashMap<String, Render>();
    private static final Map<String, Render> _lib = new HashMap<String, Render>();
    private static Render _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };
    public static Render global = new RenderManager();

    private RenderManager() {
    }

    public static void register(Render render) {
        _def = render;
        _lib.put(render.getClass().getSimpleName(), render);
        _lib.put(render.getClass().getName(), render);
        PrintUtil.blueln("solon:: view load:" + render.getClass().getSimpleName());
        PrintUtil.blueln("solon:: view load:" + render.getClass().getName());
    }

    public static void mapping(String suffix, Render render) {
        _mapping.put(suffix, render);
        PrintUtil.blueln("solon:: view mapping: " + suffix + "=" + render.getClass().getSimpleName());
    }

    public static void mapping(String suffix, String clzName) {
        Render render = _lib.get(clzName);
        if (render == null) {
            PrintUtil.redln("solon:: " + clzName + " not exists!");
            return;
        }
        _mapping.put(suffix, render);
        PrintUtil.blueln("solon:: view mapping: " + suffix + "=" + clzName);
    }

    public static String renderAndReturn(ModelAndView modelAndView) {
        try {
            return global.renderAndReturn(modelAndView, Context.current());
        }
        catch (Throwable e) {
            throw Utils.throwableWrap(e);
        }
    }

    @Override
    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        ModelAndView mv;
        if (data instanceof ModelAndView && Utils.isNotEmpty((mv = (ModelAndView)data).view())) {
            String suffix;
            Render render;
            int suffix_idx = mv.view().lastIndexOf(".");
            if (suffix_idx > 0 && (render = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                return render.renderAndReturn(mv, ctx);
            }
            return _def.renderAndReturn(mv, ctx);
        }
        throw new IllegalArgumentException("RenderAndReturn: Only support ModelAndView data");
    }

    @Override
    public void render(Object data, Context ctx) throws Throwable {
        ModelAndView mv;
        if (data instanceof ModelAndView && !Utils.isEmpty((mv = (ModelAndView)data).view())) {
            String suffix;
            Render render;
            int suffix_idx = mv.view().lastIndexOf(".");
            if (suffix_idx > 0 && (render = _mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                render.render(mv, ctx);
                return;
            }
            _def.render(mv, ctx);
            return;
        }
        Render render = null;
        String mode = ctx.header("X-Serialization");
        if (Utils.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!Utils.isEmpty(mode) && (render = _mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null && ctx.remoting()) {
            render = _mapping.get("@type_json");
        }
        if (render == null) {
            render = _mapping.get("@json");
        }
        if (render != null) {
            render.render(data, ctx);
        } else {
            _def.render(data, ctx);
        }
    }
}

