/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.BeanLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.event.PluginLoadEndEvent;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterHandler;

public class SolonApp
implements Handler,
HandlerSlots {
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private final Router _router;
    private final int _port;
    private final SolonProps _prop;
    private final Class<?> _source;
    private final long _startupTime = System.currentTimeMillis();
    private Handler _handler = null;
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = false;
    private boolean _enableWebSocketD = false;
    private boolean _enableSocketD = false;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;
    private boolean _enableSessionState = true;
    private boolean _enableJarIsolation = false;

    protected void init() {
        List<ClassLoader> loaderList;
        String filterStr = this.cfg().extendFilter();
        if (Utils.isEmpty(filterStr)) {
            loaderList = ExtendLoader.load(this.cfg().extend(), false);
        } else {
            String[] filterS = filterStr.split(",");
            loaderList = ExtendLoader.load(this.cfg().extend(), false, path -> {
                for (String f : filterS) {
                    if (!path.contains(f)) continue;
                    return true;
                }
                return false;
            });
        }
        this.cfg().plugsScan(loaderList);
    }

    protected void run() {
        List<PluginEntity> plugs = this.cfg().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        EventBus.push(PluginLoadEndEvent.instance);
        this.importTry();
        if (this.source() != null) {
            Aop.context().beanScan(this.source());
        }
        EventBus.push(BeanLoadEndEvent.instance);
        NvMap map = this.cfg().getXmap("solon.view.mapping");
        map.forEach((k, v) -> Bridge.renderMapping("." + k, v));
        Aop.context().beanLoaded();
        EventBus.push(AppLoadEndEvent.instance);
    }

    protected void importTry() {
        if (this._source == null) {
            return;
        }
        for (Annotation a1 : this._source.getAnnotations()) {
            if (a1 instanceof Import) {
                Aop.context().beanImport((Import)a1);
                continue;
            }
            Aop.context().beanImport(a1.annotationType().getAnnotation(Import.class));
        }
    }

    public ClassLoader classLoader() {
        return JarClassLoader.global();
    }

    public void beanScan(Class<?> source) {
        Aop.context().beanScan(source);
    }

    public void beanScan(String basePackage) {
        Aop.context().beanScan(basePackage);
    }

    public BeanWrap beanMake(Class<?> clz) {
        return Aop.context().beanMake(clz);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public Router router() {
        return this._router;
    }

    protected SolonApp(Class<?> source, NvMap args) {
        this._source = source;
        this._prop = new SolonProps().load(source, args);
        this._port = this._prop.serverPort();
        this._router = new Router();
        this._handler = new RouterHandler(this._router);
        this.enableJarIsolation(this._prop.getBool("solon.extend.solation", false));
    }

    protected long elapsedTimes() {
        return System.currentTimeMillis() - this._startupTime;
    }

    public Class<?> source() {
        return this._source;
    }

    public int port() {
        return this._port;
    }

    public SolonProps cfg() {
        return this._prop;
    }

    public void plug(Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin);
        p.start();
        this.cfg().plugs().add(p);
    }

    public void before(String expr, Handler handler) {
        this.before(expr, MethodType.ALL, handler);
    }

    public void before(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.before, method, handler);
    }

    @Override
    public void before(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.before, method, index, handler);
    }

    public void after(String expr, Handler handler) {
        this.after(expr, MethodType.ALL, handler);
    }

    public void after(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.after, method, handler);
    }

    @Override
    public void after(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.after, method, index, handler);
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.main, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new HandlerLoader(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new HandlerLoader(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    public void ws(String path, Handler handler) {
        this.add(path, MethodType.WEBSOCKET, handler);
    }

    public void ws(String path, Listener listener) {
        this._router.add(path, MethodType.WEBSOCKET, listener);
    }

    public void socket(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }

    public void socket(String path, Listener listener) {
        this._router.add(path, MethodType.SOCKET, listener);
    }

    public void listen(String path, Listener listener) {
        this._router.add(path, MethodType.ALL, listener);
    }

    public Handler handlerGet() {
        return this._handler;
    }

    public void handlerSet(Handler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (Solon.stopped()) {
            return;
        }
        try {
            ContextUtil.currentSet(x);
            this._handler.handle(x);
        }
        catch (Throwable ex) {
            EventBus.push(ex);
            throw ex;
        }
        finally {
            ContextUtil.currentRemove();
        }
    }

    public void tryHandle(Context x) {
        try {
            this.handle(x);
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            x.statusSet(500);
            x.setHandled(true);
            x.output(Utils.getFullStackTrace(ex));
        }
    }

    public SolonApp onError(EventListener<Throwable> handler) {
        return this.onEvent(Throwable.class, handler);
    }

    public <T> SolonApp onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public boolean enableHttp() {
        return this._enableHttp;
    }

    public SolonApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket;
    }

    public SolonApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableWebSocketD() {
        return this._enableWebSocketD;
    }

    public SolonApp enableWebSocketD(boolean enable) {
        this._enableWebSocketD = enable;
        if (enable) {
            this._enableWebSocket = enable;
        }
        return this;
    }

    public boolean enableSocketD() {
        return this._enableSocketD;
    }

    public SolonApp enableSocketD(boolean enable) {
        this._enableSocketD = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public SolonApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public SolonApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public SolonApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }

    public boolean enableSessionState() {
        return this._enableSessionState;
    }

    public SolonApp enableSessionState(boolean enable) {
        this._enableSessionState = enable;
        return this;
    }

    public boolean enableJarIsolation() {
        return this._enableJarIsolation;
    }

    private SolonApp enableJarIsolation(boolean enable) {
        this._enableJarIsolation = enable;
        return this;
    }
}

