/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.annotation.Around;
import org.noear.solon.core.Aop;
import org.noear.solon.core.handle.Interceptor;
import org.noear.solon.core.handle.InterceptorChain;
import org.noear.solon.core.handle.InterceptorChainNode;
import org.noear.solon.core.wrap.MethodHolder;
import org.noear.solon.core.wrap.ParamWrap;

public class MethodWrap
implements InterceptorChain,
MethodHolder {
    private static Map<Method, MethodWrap> cached = new HashMap<Method, MethodWrap>();
    private final Class<?> entityClz;
    private final Method method;
    private final ParamWrap[] parameters;
    private final Annotation[] annotations;
    private final List<InterceptorChainNode> arounds;
    private final InterceptorChain invokeChain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodWrap get(Method method) {
        MethodWrap mw = cached.get(method);
        if (mw == null) {
            Method method2 = method;
            synchronized (method2) {
                mw = cached.get(method);
                if (mw == null) {
                    mw = new MethodWrap(method);
                    cached.put(method, mw);
                }
            }
        }
        return mw;
    }

    protected MethodWrap(Method m) {
        this.entityClz = m.getDeclaringClass();
        this.method = m;
        this.parameters = this.paramsWrap(m.getParameters());
        this.annotations = m.getAnnotations();
        this.arounds = new ArrayList<InterceptorChainNode>();
        for (Annotation anno : this.entityClz.getAnnotations()) {
            if (anno instanceof Around) {
                this.doAroundAdd((Around)anno);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(Around.class));
        }
        for (Annotation anno : this.annotations) {
            if (anno instanceof Around) {
                this.doAroundAdd((Around)anno);
                continue;
            }
            this.doAroundAdd(anno.annotationType().getAnnotation(Around.class));
        }
        if (this.arounds.size() > 0) {
            this.arounds.sort(Comparator.comparing(x -> x.index));
            InterceptorChainNode node = this.arounds.get(0);
            int len = this.arounds.size();
            for (int i = 1; i < len; ++i) {
                node.next = this.arounds.get(i);
                node = this.arounds.get(i);
            }
            node.next = this;
            this.invokeChain = this.arounds.get(0);
        } else {
            this.invokeChain = this;
        }
    }

    private ParamWrap[] paramsWrap(Parameter[] pAry) {
        ParamWrap[] tmp = new ParamWrap[pAry.length];
        int len = pAry.length;
        for (int i = 0; i < len; ++i) {
            tmp[i] = new ParamWrap(pAry[i]);
        }
        return tmp;
    }

    private void doAroundAdd(Around a) {
        if (a != null) {
            this.arounds.add(new InterceptorChainNode(this, a.index(), (Interceptor)Aop.get(a.value())));
        }
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Override
    public ParamWrap[] getParamWraps() {
        return this.parameters;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.method.getAnnotation(type);
    }

    @Override
    public MethodHolder method() {
        return this;
    }

    @Override
    public Object doIntercept(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invoke(Object obj, Object[] args) throws Exception {
        return this.method.invoke(obj, args);
    }

    public Object invokeByAspect(Object obj, Object[] args) throws Throwable {
        return this.invokeChain.doIntercept(obj, args);
    }
}

