/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.ext.ConsumerEx;

public class Solon {
    private static int stopDelay = 10;
    private static SolonApp global;

    public static SolonApp global() {
        return global;
    }

    public static SolonProps cfg() {
        return Solon.global().cfg();
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        RuntimeMXBean rb;
        if (global != null) {
            return global;
        }
        JarClassLoader.bindingThread();
        PrintUtil.blueln("solon.App:: Start loading");
        global = new SolonApp(source, argx);
        global.init();
        if (initialize != null) {
            try {
                initialize.accept(global);
            }
            catch (Throwable ex) {
                throw Utils.throwableWrap(ex);
            }
        }
        global.run();
        stopDelay = Solon.cfg().getInt("solon.stop.delay", 10);
        if (global.enableSafeStop()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, stopDelay)));
        }
        if ((rb = ManagementFactory.getRuntimeMXBean()) == null) {
            PrintUtil.blueln("solon.App:: End loading @" + global.elapsedTimes() + "ms");
        } else {
            PrintUtil.blueln("solon.App:: End loading @" + global.elapsedTimes() + "ms pid=" + rb.getName());
        }
        return global;
    }

    public static void stopDelaySet(int delay) {
        stopDelay = delay;
    }

    public static void stop() {
        Solon.stop(stopDelay);
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    private static void stop0(boolean exit, int delay) {
        if (Solon.global() == null) {
            return;
        }
        String hint = "(1.prestop 2.delay 3.stop)";
        PrintUtil.red("[Security to stop] ");
        System.out.println("begin..." + hint);
        Solon.cfg().plugs().forEach(p -> p.prestop());
        PrintUtil.red("[Security to stop] ");
        System.out.println("1 completed " + hint);
        if (delay > 0) {
            try {
                Thread.sleep(delay * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            PrintUtil.red("[Security to stop] ");
            System.out.println("2 completed " + hint);
        }
        Solon.cfg().plugs().forEach(p -> p.stop());
        PrintUtil.red("[Security to stop] ");
        System.out.println("3 completed " + hint);
        if (exit) {
            System.exit(1);
        }
    }
}

