/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Bridge;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecutor;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.ext.DataThrowable;
import org.noear.solon.ext.RunnableEx;

public class Action
extends HandlerAide
implements Handler {
    private final BeanWrap bWrap;
    private final HandlerAide bAide;
    private Render bRender;
    private final boolean mIsMain;
    private final MethodWrap mWrap;
    private String mProduces;
    private String mConsumes;
    private final String mName;
    private final boolean mRemoting;
    private final Mapping mMapping;
    private PathAnalyzer pathAnalyzer;
    private List<String> pathKeys;
    private static Pattern pathKeyExpr = Pattern.compile("\\{([^\\\\}]+)\\}");

    public Action(BeanWrap bWrap, Method method) {
        this(bWrap, null, method, null, null, false, null);
    }

    public Action(BeanWrap bWrap, HandlerAide bAide, Method method, Mapping mapping, String path, boolean remoting, Render render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        method.setAccessible(true);
        this.mWrap = MethodWrap.get(method);
        this.mRemoting = remoting;
        this.mMapping = mapping;
        this.bRender = render;
        if (this.bRender == null && Render.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (Render)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
            this.mIsMain = true;
        } else {
            this.mProduces = mapping.produces();
            this.mConsumes = mapping.consumes();
            this.mName = Utils.annoAlias(mapping.value(), mapping.path());
            boolean bl = this.mIsMain = !mapping.after() && !mapping.before();
        }
        if (path != null && path.indexOf("{") >= 0) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = PathAnalyzer.get(path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public Mapping mapping() {
        return this.mMapping;
    }

    public MethodWrap method() {
        return this.mWrap;
    }

    public BeanWrap bean() {
        return this.bWrap;
    }

    public String produces() {
        return this.mProduces;
    }

    public String consumes() {
        return this.mConsumes;
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (Utils.isNotEmpty(this.mConsumes) && (x.contentType() == null || !x.contentType().contains(this.mConsumes))) {
            x.statusSet(415);
            return;
        }
        this.invoke(x, null);
    }

    public void invoke(Context c, Object obj) throws Throwable {
        c.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get();
            }
            if (this.mIsMain) {
                c.attrSet("controller", obj);
                c.attrSet("action", this);
            }
            this.invoke0(c, obj);
        }
        catch (Throwable e) {
            c.errors = e = Utils.throwableUnwrap(e);
            EventBus.push(e);
            if (c.result == null) {
                this.renderDo(e, c);
            }
            this.renderDo(c.result, c);
        }
    }

    protected void invoke0(Context c, Object obj) throws Throwable {
        if (this.mIsMain) {
            this.handleDo(c, () -> {
                if (this.bAide != null) {
                    for (Handler h : this.bAide.befores) {
                        h.handle(c);
                    }
                }
                for (Handler h : this.befores) {
                    h.handle(c);
                }
            });
        }
        if (!this.mIsMain || !c.getHandled()) {
            this.handleDo(c, () -> {
                Matcher pm;
                if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(c.path())).find()) {
                    int len = this.pathKeys.size();
                    for (int i = 0; i < len; ++i) {
                        c.paramSet(this.pathKeys.get(i), pm.group(i + 1));
                    }
                }
                Object tmp = this.callDo(c, obj, this.mWrap);
                if (this.mIsMain) {
                    c.result = tmp;
                    if (!Utils.isEmpty(this.mProduces)) {
                        c.contentType(this.mProduces);
                    }
                    this.renderDo(tmp, c);
                }
            });
        }
        if (this.mIsMain) {
            if (this.bAide != null) {
                for (Handler h : this.bAide.afters) {
                    h.handle(c);
                }
            }
            for (Handler h : this.afters) {
                h.handle(c);
            }
        }
    }

    protected void handleDo(Context c, RunnableEx runnable) throws Throwable {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            EventBus.push(e);
            if (c.result == null) {
                this.renderDo(e, c);
            }
            this.renderDo(c.result, c);
        }
    }

    protected Object callDo(Context ctx, Object obj, MethodWrap mWrap) throws Throwable {
        String ct = ctx.contentType();
        if (mWrap.getParamWraps().length > 0) {
            for (ActionExecutor me : Bridge.actionExecutors()) {
                if (!me.matched(ctx, ct)) continue;
                return me.execute(ctx, obj, mWrap);
            }
        }
        return Bridge.actionExecutorDef().execute(ctx, obj, mWrap);
    }

    protected void renderDo(Object obj, Context c) throws Throwable {
        if (c.getRendered()) {
            return;
        }
        c.result = obj;
        if (this.bRender == null) {
            if (obj instanceof DataThrowable) {
                return;
            }
            c.setRendered(true);
            if (obj instanceof Throwable) {
                if (c.remoting()) {
                    c.render(obj);
                } else {
                    if (c.status() < 400) {
                        c.statusSet(500);
                    }
                    if (Solon.cfg().isDebugMode()) {
                        c.output(Utils.getFullStackTrace((Throwable)obj));
                    }
                }
            } else {
                c.render(obj);
            }
        } else {
            this.bRender.render(obj, c);
        }
    }
}

