/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Import;
import org.noear.solon.core.Aop;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.ExtendLoader;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.PluginEntity;
import org.noear.solon.core.Signal;
import org.noear.solon.core.event.AppInitEndEvent;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.event.BeanLoadEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.event.PluginLoadEndEvent;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextUtil;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;
import org.noear.solon.core.handle.FilterChainNode;
import org.noear.solon.core.handle.FilterEntity;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerLoader;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterDefault;
import org.noear.solon.core.route.RouterHandler;
import org.noear.solon.core.util.PrintUtil;

public class SolonApp
implements HandlerSlots {
    private final SolonProps _prop;
    private final Class<?> _source;
    private final long _startupTime;
    private List<FilterEntity> _filterList = new ArrayList<FilterEntity>();
    protected boolean stopped = false;
    private final Map<Integer, Signal> signals = new LinkedHashMap<Integer, Signal>();
    private final Set<BiConsumer<String, Object>> _onSharedAdd_event = new HashSet<BiConsumer<String, Object>>();
    private final Map<String, Object> _shared = new HashMap<String, Object>();
    private Map<String, Object> _shared_unmod;
    private RouterHandler _routerHandler;
    private Router _router;
    private Handler _handler = null;
    private boolean _enableHttp = true;
    private boolean _enableWebSocket = false;
    private boolean _enableWebSocketD = false;
    private boolean _enableSocketD = false;
    private boolean _enableTransaction = true;
    private boolean _enableCaching = true;
    private boolean _enableStaticfiles = true;
    private boolean _enableErrorAutoprint = true;
    private boolean _enableSessionState = true;
    private boolean _enableJarIsolation = false;
    private boolean _enableSafeStop = false;

    protected SolonApp(Class<?> source, NvMap args) {
        this._startupTime = System.currentTimeMillis();
        this._source = source;
        this._prop = new SolonProps().load(source, args);
        this._router = new RouterDefault();
        this._routerHandler = new RouterHandler(this._router);
        this._filterList.add(new FilterEntity(Integer.MAX_VALUE, this::doFilter));
        this._handler = this._routerHandler;
        this.enableJarIsolation(this._prop.getBool("solon.extend.isolation", false));
    }

    protected void initAwait() {
        String addr = this.cfg().get("solon.start.ping");
        if (Utils.isNotEmpty(addr)) {
            try {
                while (true) {
                    if (Utils.ping(addr)) {
                        PrintUtil.info("App", "Start ping succeed: " + addr);
                        Thread.sleep(1000L);
                        break;
                    }
                    PrintUtil.info("App", "Start ping failure: " + addr);
                    Thread.sleep(2000L);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void init() {
        List<ClassLoader> loaderList;
        String filterStr = this.cfg().extendFilter();
        if (Utils.isEmpty(filterStr)) {
            loaderList = ExtendLoader.load(this.cfg().extend(), false);
        } else {
            String[] filterS = filterStr.split(",");
            loaderList = ExtendLoader.load(this.cfg().extend(), false, path -> {
                for (String f : filterS) {
                    if (!path.contains(f)) continue;
                    return true;
                }
                return false;
            });
        }
        this.cfg().plugsScan(loaderList);
    }

    protected void run() {
        EventBus.push(AppInitEndEvent.instance);
        List<PluginEntity> plugs = this.cfg().plugs();
        int len = plugs.size();
        for (int i = 0; i < len; ++i) {
            plugs.get(i).start();
        }
        EventBus.push(PluginLoadEndEvent.instance);
        this.importTry();
        if (this.source() != null) {
            Aop.context().beanScan(this.source());
        }
        EventBus.push(BeanLoadEndEvent.instance);
        NvMap map = this.cfg().getXmap("solon.view.mapping");
        map.forEach((k, v) -> RenderManager.mapping("." + k, v));
        Aop.context().beanLoaded();
        EventBus.push(AppLoadEndEvent.instance);
    }

    protected void importTry() {
        if (this._source == null) {
            return;
        }
        for (Annotation a1 : this._source.getAnnotations()) {
            if (a1 instanceof Import) {
                Aop.context().beanImport((Import)a1);
                continue;
            }
            Aop.context().beanImport(a1.annotationType().getAnnotation(Import.class));
        }
    }

    public void signalAdd(Signal instance) {
        this.signals.putIfAbsent(instance.port(), instance);
    }

    public Signal signalGet(int port) {
        return this.signals.get(port);
    }

    public Collection<Signal> signals() {
        return Collections.unmodifiableCollection(this.signals.values());
    }

    public ClassLoader classLoader() {
        return JarClassLoader.global();
    }

    public void beanScan(Class<?> source) {
        Aop.context().beanScan(source);
    }

    public void beanScan(String basePackage) {
        Aop.context().beanScan(basePackage);
    }

    public BeanWrap beanMake(Class<?> clz) {
        return Aop.context().beanMake(clz);
    }

    public void sharedAdd(String key, Object obj) {
        this._shared.put(key, obj);
        this._onSharedAdd_event.forEach(fun -> fun.accept(key, obj));
    }

    public <T> void sharedGet(String key, Consumer<T> event) {
        Object tmp = this._shared.get(key);
        if (tmp != null) {
            event.accept(tmp);
        } else {
            this.onSharedAdd((k, v) -> {
                if (k.equals(key)) {
                    event.accept(v);
                }
            });
        }
    }

    public void onSharedAdd(BiConsumer<String, Object> event) {
        this._onSharedAdd_event.add(event);
    }

    public Map<String, Object> shared() {
        if (this._shared_unmod == null) {
            this._shared_unmod = Collections.unmodifiableMap(this._shared);
        }
        return this._shared_unmod;
    }

    public Router router() {
        return this._router;
    }

    public void routerSet(Router router) {
        if (router != null) {
            this._router = router;
            this._routerHandler.bind(router);
        }
    }

    protected long elapsedTimes() {
        return System.currentTimeMillis() - this._startupTime;
    }

    public Class<?> source() {
        return this._source;
    }

    public int port() {
        return this._prop.serverPort();
    }

    public SolonProps cfg() {
        return this._prop;
    }

    public void plug(Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin);
        p.start();
        this.cfg().plugs().add(p);
    }

    public void pluginAdd(int priority, Plugin plugin) {
        PluginEntity p = new PluginEntity(plugin, priority);
        this.cfg().plugs().add(p);
        this.cfg().plugsSort();
    }

    public void filter(Filter filter) {
        this.filter(0, filter);
    }

    public void filter(int index, Filter filter) {
        this._filterList.add(new FilterEntity(index, filter));
        this._filterList.sort(Comparator.comparingInt(f -> f.index));
    }

    public void before(Handler handler) {
        this.before("**", MethodType.ALL, handler);
    }

    public void before(int index, Handler handler) {
        this.before("**", MethodType.ALL, index, handler);
    }

    public void before(MethodType method, Handler handler) {
        this.before("**", method, handler);
    }

    public void before(MethodType method, int index, Handler handler) {
        this.before("**", method, index, handler);
    }

    public void before(String expr, Handler handler) {
        this.before(expr, MethodType.ALL, handler);
    }

    public void before(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.before, method, handler);
    }

    @Override
    public void before(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.before, method, index, handler);
    }

    public void after(Handler handler) {
        this.after("**", MethodType.ALL, handler);
    }

    public void after(MethodType method, Handler handler) {
        this.after("**", method, handler);
    }

    public void after(String expr, Handler handler) {
        this.after(expr, MethodType.ALL, handler);
    }

    public void after(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.after, method, handler);
    }

    @Override
    public void after(String expr, MethodType method, int index, Handler handler) {
        this._router.add(expr, Endpoint.after, method, index, handler);
    }

    @Override
    public void add(String expr, MethodType method, Handler handler) {
        this._router.add(expr, Endpoint.main, method, handler);
    }

    public void add(String expr, Class<?> clz) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new HandlerLoader(bw, expr).load(this);
        }
    }

    public void add(String expr, Class<?> clz, boolean remoting) {
        BeanWrap bw = Aop.wrapAndPut(clz);
        if (bw != null) {
            new HandlerLoader(bw, expr, remoting).load(this);
        }
    }

    public void all(String path, Handler handler) {
        this.add(path, MethodType.ALL, handler);
    }

    public void http(String path, Handler handler) {
        this.add(path, MethodType.HTTP, handler);
    }

    public void head(String path, Handler handler) {
        this.add(path, MethodType.HEAD, handler);
    }

    public void get(String path, Handler handler) {
        this.add(path, MethodType.GET, handler);
    }

    public void post(String path, Handler handler) {
        this.add(path, MethodType.POST, handler);
    }

    public void put(String path, Handler handler) {
        this.add(path, MethodType.PUT, handler);
    }

    public void patch(String path, Handler handler) {
        this.add(path, MethodType.PATCH, handler);
    }

    public void delete(String path, Handler handler) {
        this.add(path, MethodType.DELETE, handler);
    }

    public void ws(String path, Handler handler) {
        this.add(path, MethodType.WEBSOCKET, handler);
    }

    public void ws(String path, Listener listener) {
        this._router.add(path, MethodType.WEBSOCKET, listener);
    }

    public void socket(String path, Handler handler) {
        this.add(path, MethodType.SOCKET, handler);
    }

    public void socket(String path, Listener listener) {
        this._router.add(path, MethodType.SOCKET, listener);
    }

    public void listen(String path, Listener listener) {
        this._router.add(path, MethodType.ALL, listener);
    }

    public Handler handlerGet() {
        return this._handler;
    }

    public void handlerSet(Handler handler) {
        if (handler != null) {
            this._handler = handler;
        }
    }

    public void tryHandle(Context x) {
        try {
            ContextUtil.currentSet(x);
            if (this.stopped) {
                x.status(403);
            } else {
                new FilterChainNode(this._filterList).doFilter(x);
            }
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            if (!ex.equals(x.errors)) {
                EventBus.push(ex);
            }
            if (!x.getHandled()) {
                if (x.status() < 400) {
                    x.status(500);
                }
                x.setHandled(true);
            }
            if (!x.getRendered() && Solon.cfg().isDebugMode()) {
                x.output(ex);
            }
        }
        finally {
            ContextUtil.currentRemove();
        }
    }

    protected void doFilter(Context ctx, FilterChain chain) throws Throwable {
        this._handler.handle(ctx);
    }

    public <T> SolonApp onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public SolonApp onError(EventListener<Throwable> handler) {
        return this.onEvent(Throwable.class, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() throws InterruptedException {
        SolonApp solonApp = this;
        synchronized (solonApp) {
            this.wait();
        }
    }

    public boolean enableHttp() {
        return this._enableHttp;
    }

    public SolonApp enableHttp(boolean enable) {
        this._enableHttp = enable;
        return this;
    }

    public boolean enableWebSocket() {
        return this._enableWebSocket;
    }

    public SolonApp enableWebSocket(boolean enable) {
        this._enableWebSocket = enable;
        return this;
    }

    public boolean enableWebSocketD() {
        return this._enableWebSocketD;
    }

    public SolonApp enableWebSocketD(boolean enable) {
        this._enableWebSocketD = enable;
        if (enable) {
            this._enableWebSocket = enable;
        }
        return this;
    }

    public boolean enableSocketD() {
        return this._enableSocketD;
    }

    public SolonApp enableSocketD(boolean enable) {
        this._enableSocketD = enable;
        return this;
    }

    public boolean enableTransaction() {
        return this._enableTransaction;
    }

    public SolonApp enableTransaction(boolean enable) {
        this._enableTransaction = enable;
        return this;
    }

    public boolean enableCaching() {
        return this._enableCaching;
    }

    public SolonApp enableCaching(boolean enable) {
        this._enableCaching = enable;
        return this;
    }

    public boolean enableStaticfiles() {
        return this._enableStaticfiles;
    }

    public SolonApp enableStaticfiles(boolean enable) {
        this._enableStaticfiles = enable;
        return this;
    }

    public boolean enableErrorAutoprint() {
        return this._enableErrorAutoprint;
    }

    public void enableErrorAutoprint(boolean enable) {
        this._enableErrorAutoprint = enable;
    }

    public boolean enableSessionState() {
        return this._enableSessionState;
    }

    public SolonApp enableSessionState(boolean enable) {
        this._enableSessionState = enable;
        return this;
    }

    public boolean enableJarIsolation() {
        return this._enableJarIsolation;
    }

    private SolonApp enableJarIsolation(boolean enable) {
        this._enableJarIsolation = enable;
        return this;
    }

    public boolean enableSafeStop() {
        return this._enableSafeStop;
    }

    public void enableSafeStop(boolean enable) {
        this._enableSafeStop = enable;
    }
}

