/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.util.PathUtil;

public class ListenerHolder
implements Listener {
    private Listener listener;
    private PathAnalyzer pathAnalyzer;
    private List<String> pathKeys;

    public ListenerHolder(String path, Listener listener) {
        this.listener = listener;
        if (path != null && path.indexOf("{") >= 0) {
            path = PathUtil.mergePath(null, path);
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathAnalyzer = PathAnalyzer.get(path);
            }
        }
    }

    @Override
    public void onOpen(Session s) {
        Matcher pm;
        if (this.pathAnalyzer != null && (pm = this.pathAnalyzer.matcher(s.path())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                s.paramSet(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
        this.listener.onOpen(s);
    }

    @Override
    public void onMessage(Session s, Message m) throws IOException {
        this.listener.onMessage(s, m);
    }

    @Override
    public void onClose(Session s) {
        this.listener.onClose(s);
    }

    @Override
    public void onError(Session s, Throwable e) {
        this.listener.onError(s, e);
    }
}

