/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.util.PathAnalyzer;

public class RoutingDefault<T>
implements Routing<T> {
    private final PathAnalyzer rule;
    private final int index;
    private final String path;
    private final T target;
    private final MethodType method;

    public RoutingDefault(String path, MethodType method, int index, T target) {
        this.rule = PathAnalyzer.get(path);
        this.method = method;
        this.path = path;
        this.index = index;
        this.target = target;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public T target() {
        return this.target;
    }

    @Override
    public MethodType method() {
        return this.method;
    }

    @Override
    public boolean matches(MethodType method2, String path2) {
        if (MethodType.ALL == this.method) {
            return this.matches0(path2);
        }
        if (MethodType.HTTP == this.method ? method2.signal == SignalType.HTTP : method2 == this.method) {
            return this.matches0(path2);
        }
        return false;
    }

    private boolean matches0(String path2) {
        if ("**".equals(this.path) || "/**".equals(this.path)) {
            return true;
        }
        if (this.path.equals(path2)) {
            return true;
        }
        return this.rule.matches(path2);
    }
}

