/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.JarClassLoader;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.util.PrintUtil;
import org.noear.solon.ext.ConsumerEx;

public class Solon {
    private static int stopDelay = 10;
    private static SolonApp global;
    private static String encoding;

    public static SolonApp global() {
        return global;
    }

    public static SolonProps cfg() {
        return Solon.global().cfg();
    }

    public static String encoding() {
        return encoding;
    }

    public static void encodingSet(String charset) {
        if (global == null && Utils.isNotEmpty(charset)) {
            encoding = charset;
        }
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        if (global != null) {
            return global;
        }
        if (Utils.isNotEmpty(encoding)) {
            System.setProperty("file.encoding", encoding);
        }
        System.getProperties().putIfAbsent("java.awt.headless", "true");
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        String pid = rb.getName().split("@")[0];
        System.setProperty("PID", pid);
        JarClassLoader.bindingThread();
        PrintUtil.info("App", "Start loading");
        global = new SolonApp(source, argx);
        global.initAwait();
        try {
            global.init();
            if (initialize != null) {
                initialize.accept(global);
            }
            global.run();
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            EventBus.push(ex);
            if (!global.enableErrorAutoprint()) {
                ex.printStackTrace();
            }
            Solon.stop0(true, 0);
            return null;
        }
        stopDelay = Solon.cfg().getInt("solon.stop.delay", 10);
        if (global.enableSafeStop()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, stopDelay)));
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, 0)));
        }
        PrintUtil.info("App", "End loading elapsed=" + global.elapsedTimes() + "ms pid=" + pid);
        return global;
    }

    public static void stopDelaySet(int delay) {
        stopDelay = delay;
    }

    public static void stop() {
        Solon.stop(stopDelay);
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    private static void stop0(boolean exit, int delay) {
        if (Solon.global() == null) {
            return;
        }
        if (delay > 0) {
            String hint = "(1.prestop 2.delay 3.stop)";
            PrintUtil.info("App", "Security to stop: begin..." + hint);
            Solon.cfg().plugs().forEach(p -> p.prestop());
            PrintUtil.info("App", "Security to stop: 1 completed " + hint);
            int delay1 = (int)((double)delay * 0.2);
            int delay2 = delay - delay1;
            if (delay1 > 0) {
                Solon.sleep0(delay1);
            }
            Solon.global().stopped = true;
            if (delay2 > 0) {
                Solon.sleep0(delay2);
            }
            PrintUtil.info("App", "Security to stop: 2 completed " + hint);
            Solon.cfg().plugs().forEach(p -> p.stop());
            PrintUtil.info("App", "Security to stop: 3 completed " + hint);
        } else {
            Solon.cfg().plugs().forEach(p -> p.prestop());
            Solon.global().stopped = true;
            Solon.cfg().plugs().forEach(p -> p.stop());
        }
        if (exit) {
            System.exit(1);
        }
    }

    private static void sleep0(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        encoding = "utf-8";
    }
}

