/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChainImpl;
import org.noear.solon.core.handle.FilterEntity;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChainImpl;
import org.noear.solon.core.route.RouterInterceptorEntity;
import org.noear.solon.lang.Nullable;

public class ChainManager {
    private final List<FilterEntity> _filterNodes = new ArrayList<FilterEntity>();
    private final List<RouterInterceptorEntity> _interceptorNodes = new ArrayList<RouterInterceptorEntity>();

    public synchronized void addFilter(Filter filter, int index) {
        this._filterNodes.add(new FilterEntity(index, filter));
        this._filterNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doFilter(Context x) throws Throwable {
        new FilterChainImpl(this._filterNodes).doFilter(x);
    }

    public synchronized void addInterceptor(RouterInterceptor interceptor, int index) {
        RouterInterceptorEntity node = new RouterInterceptorEntity(index, interceptor);
        this._interceptorNodes.add(node);
        this._interceptorNodes.sort(Comparator.comparingInt(f -> f.index));
    }

    public void doIntercept(Context x, @Nullable Handler mainHandler) throws Throwable {
        new RouterInterceptorChainImpl(this._interceptorNodes).doIntercept(x, mainHandler);
    }

    public Object postResult(Context x, @Nullable Object result) throws Throwable {
        for (RouterInterceptorEntity e : this._interceptorNodes) {
            result = e.interceptor.postResult(x, result);
        }
        return result;
    }
}

