/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import java.util.Collection;
import java.util.List;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.message.Listener;
import org.noear.solon.core.message.ListenerHolder;
import org.noear.solon.core.message.Session;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.Routing;
import org.noear.solon.core.route.RoutingDefault;
import org.noear.solon.core.route.RoutingTable;
import org.noear.solon.core.route.RoutingTableDefault;

public class RouterDefault
implements Router {
    private final RoutingTable<Handler>[] routesH = new RoutingTableDefault[3];
    private final RoutingTable<Listener> routesL;

    public RouterDefault() {
        this.routesH[0] = new RoutingTableDefault<Handler>();
        this.routesH[1] = new RoutingTableDefault<Handler>();
        this.routesH[2] = new RoutingTableDefault<Handler>();
        this.routesL = new RoutingTableDefault<Listener>();
    }

    @Override
    public void add(String path, Endpoint endpoint, MethodType method, int index, Handler handler) {
        RoutingDefault<Handler> routing = new RoutingDefault<Handler>(path, method, index, handler);
        if (path.contains("*") || path.contains("{")) {
            this.routesH[endpoint.code].add(routing);
        } else {
            this.routesH[endpoint.code].add(0, routing);
        }
    }

    @Override
    public void remove(String pathPrefix) {
        this.routesH[Endpoint.before.code].remove(pathPrefix);
        this.routesH[Endpoint.main.code].remove(pathPrefix);
        this.routesH[Endpoint.after.code].remove(pathPrefix);
    }

    @Override
    public Collection<Routing<Handler>> getAll(Endpoint endpoint) {
        return this.routesH[endpoint.code].getAll();
    }

    @Override
    public Handler matchOne(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchOne(pathNew, method);
    }

    @Override
    public List<Handler> matchAll(Context ctx, Endpoint endpoint) {
        String pathNew = ctx.pathNew();
        MethodType method = MethodTypeUtil.valueOf(ctx.method());
        return this.routesH[endpoint.code].matchAll(pathNew, method);
    }

    @Override
    public void add(String path, MethodType method, int index, Listener listener) {
        ListenerHolder lh = new ListenerHolder(path, listener);
        this.routesL.add(new RoutingDefault<ListenerHolder>(path, method, index, lh));
    }

    @Override
    public Listener matchOne(Session session) {
        String path = session.pathNew();
        if (path == null) {
            return null;
        }
        return this.routesL.matchOne(path, session.method());
    }

    @Override
    public List<Listener> matchAll(Session session) {
        String path = session.pathNew();
        if (path == null) {
            return null;
        }
        return this.routesL.matchAll(path, session.method());
    }

    @Override
    public void clear() {
        this.routesH[0].clear();
        this.routesH[1].clear();
        this.routesH[2].clear();
        this.routesL.clear();
    }
}

