/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Consumes;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.Produces;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.PathAnalyzer;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.core.wrap.MethodWrap;

public class Action
extends HandlerAide
implements Handler {
    private final BeanWrap bWrap;
    private final HandlerAide bAide;
    private Render bRender;
    private final MethodWrap mWrap;
    private String mProduces;
    private String mConsumes;
    private final String mName;
    private final String mFullName;
    private final boolean mRemoting;
    private final Mapping mMapping;
    private boolean mMultipart;
    private PathAnalyzer pathKeysAnalyzer;
    private List<String> pathKeys;

    public Action(BeanWrap bWrap, Method method) {
        this(bWrap, null, method, null, null, false, null);
    }

    public Action(BeanWrap bWrap, HandlerAide bAide, Method method, Mapping mapping, String path, boolean remoting, Render render) {
        this.bWrap = bWrap;
        this.bAide = bAide;
        method.setAccessible(true);
        this.mWrap = bWrap.context().methodGet(method);
        this.mRemoting = remoting;
        this.mMapping = mapping;
        this.bRender = render;
        if (this.bRender == null && Render.class.isAssignableFrom(bWrap.clz())) {
            this.bRender = (Render)bWrap.raw();
        }
        if (mapping == null) {
            this.mName = method.getName();
        } else {
            Class<?>[] producesAnno = method.getAnnotation(Produces.class);
            Consumes consumesAnno = method.getAnnotation(Consumes.class);
            this.mProduces = producesAnno == null ? mapping.produces() : producesAnno.value();
            this.mConsumes = consumesAnno == null ? mapping.consumes() : consumesAnno.value();
            this.mMultipart = mapping.multipart();
            this.mName = Utils.annoAlias(mapping.value(), mapping.path());
        }
        this.mFullName = Utils.isEmpty(path) ? this.mName : (path.startsWith("/") ? path.substring(1) : path);
        if (!this.mMultipart) {
            for (Class<?> clz : method.getParameterTypes()) {
                if (!UploadedFile.class.isAssignableFrom(clz)) continue;
                this.mMultipart = true;
            }
        }
        if (path != null && path.contains("{")) {
            this.pathKeys = new ArrayList<String>();
            Matcher pm = PathUtil.pathKeyExpr.matcher(path);
            while (pm.find()) {
                this.pathKeys.add(pm.group(1));
            }
            if (this.pathKeys.size() > 0) {
                this.pathKeysAnalyzer = PathAnalyzer.get(path);
            }
        }
    }

    public String name() {
        return this.mName;
    }

    public String fullName() {
        return this.mFullName;
    }

    public Mapping mapping() {
        return this.mMapping;
    }

    public MethodWrap method() {
        return this.mWrap;
    }

    public BeanWrap controller() {
        return this.bWrap;
    }

    public String produces() {
        return this.mProduces;
    }

    public String consumes() {
        return this.mConsumes;
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (Utils.isNotEmpty(this.mConsumes) && (x.contentType() == null || !x.contentType().contains(this.mConsumes))) {
            x.status(415);
            return;
        }
        if (this.mMultipart) {
            x.autoMultipart(true);
        }
        this.invoke(x, null);
    }

    public void invoke(Context c, Object obj) throws Throwable {
        c.remotingSet(this.mRemoting);
        try {
            if (obj == null) {
                obj = this.bWrap.get();
            }
            c.attrSet("controller", obj);
            c.attrSet("action", this);
            this.invoke0(c, obj);
        }
        catch (Throwable e) {
            c.setHandled(true);
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                } else {
                    this.renderDo(ex.data(), c);
                }
            }
            c.errors = e;
            this.renderDo(e, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke0(Context c, Object obj) throws Throwable {
        try {
            if (this.bAide != null) {
                for (Handler h : this.bAide.befores) {
                    h.handle(c);
                }
            }
            for (Handler h : this.befores) {
                h.handle(c);
            }
            if (!c.getHandled()) {
                Object returnHandler;
                this.bindPathVarDo(c);
                c.result = this.executeDo(c, obj);
                if (!Utils.isEmpty(this.mProduces)) {
                    c.contentType(this.mProduces);
                }
                if ((returnHandler = Solon.app().chainManager().getReturnHandler(this.method().getReturnType())) != null) {
                    returnHandler.returnHandle(c, this, c.result);
                } else {
                    this.renderDo(c.result, c);
                }
            }
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof DataThrowable) {
                DataThrowable ex = (DataThrowable)e;
                if (ex.data() == null) {
                    this.renderDo(ex, c);
                }
                this.renderDo(ex.data(), c);
            }
            c.errors = e;
            throw e;
        }
        finally {
            if (this.bAide != null) {
                for (Handler h : this.bAide.afters) {
                    h.handle(c);
                }
            }
            for (Handler h : this.afters) {
                h.handle(c);
            }
        }
    }

    private void bindPathVarDo(Context c) throws Throwable {
        Matcher pm;
        if (this.pathKeysAnalyzer != null && (pm = this.pathKeysAnalyzer.matcher(c.pathNew())).find()) {
            int len = this.pathKeys.size();
            for (int i = 0; i < len; ++i) {
                c.paramSet(this.pathKeys.get(i), pm.group(i + 1));
            }
        }
    }

    protected Object executeDo(Context c, Object obj) throws Throwable {
        ActionExecuteHandler executeHandler = Solon.app().chainManager().getExecuteHandler(c, this.mWrap.getParamWraps().length);
        return executeHandler.executeHandle(c, obj, this.mWrap);
    }

    public void render(Object obj, Context c) throws Throwable {
        this.renderDo(obj, c);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void renderDo(Object obj, Context c) throws Throwable {
        obj = Solon.app().chainManager().postResult(c, obj);
        if (!c.getRendered()) {
            c.result = obj;
        }
        if (this.bRender != null) {
            this.bRender.render(obj, c);
            return;
        }
        if (obj instanceof DataThrowable) {
            return;
        }
        if (!(obj instanceof Throwable)) {
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        if (c.remoting()) {
            EventBus.pushTry(obj);
            if (c.getRendered()) return;
            c.render(obj);
            return;
        }
        c.setHandled(false);
        throw (Throwable)obj;
    }
}

