/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.noear.solon.Utils;
import org.noear.solon.core.util.NamedThreadFactory;
import org.noear.solon.core.util.RunnableEx;

public class RunUtil {
    private static ExecutorService parallelExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("Solon-executor-"));
    private static ExecutorService asyncExecutor;
    private static ScheduledExecutorService scheduledExecutor;

    public static void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        if (scheduledExecutor != null) {
            ScheduledExecutorService old = RunUtil.scheduledExecutor;
            RunUtil.scheduledExecutor = scheduledExecutor;
            old.shutdown();
        }
    }

    @Deprecated
    public static void setExecutor(ExecutorService executor) {
        RunUtil.setParallelExecutor(executor);
    }

    public static void setParallelExecutor(ExecutorService parallelExecutor) {
        if (parallelExecutor != null) {
            ExecutorService old = RunUtil.parallelExecutor;
            RunUtil.parallelExecutor = parallelExecutor;
            old.shutdown();
        }
    }

    public static void setAsyncExecutor(ExecutorService asyncExecutor) {
        if (asyncExecutor != null) {
            ExecutorService old = RunUtil.asyncExecutor;
            RunUtil.asyncExecutor = asyncExecutor;
            old.shutdown();
        }
    }

    public static void runOrThrow(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void runAndTry(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Future<?> parallel(Runnable task) {
        return parallelExecutor.submit(task);
    }

    public static <T> Future<T> parallel(Callable<T> task) {
        return parallelExecutor.submit(task);
    }

    public static CompletableFuture<Void> async(Runnable task) {
        return CompletableFuture.runAsync(task, asyncExecutor);
    }

    public static <U> CompletableFuture<U> async(Supplier<U> task) {
        return CompletableFuture.supplyAsync(task, asyncExecutor);
    }

    public static ScheduledFuture<?> delay(Runnable task, long millis) {
        return scheduledExecutor.schedule(task, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delayAndRepeat(Runnable task, long millis) {
        return scheduledExecutor.scheduleWithFixedDelay(task, 1000L, millis, TimeUnit.MILLISECONDS);
    }

    static {
        int asyncPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        asyncExecutor = new ThreadPoolExecutor(asyncPoolSize, asyncPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Solon-asyncExecutor-"));
        scheduledExecutor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("Solon-echeduledExecutor-"));
    }
}

