package org.noear.solon.core;

import org.noear.solon.lang.Nullable;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;

/**
 * 变量容器（主要在 BeanInjector 中使用）
 *
 * <pre><code>
 * //@Db 注入器添加
 * context.beanInjectorAdd(Db.classs, (varH, anno)->{
 *     ...
 * });
 * </code></pre>
 *
 * @author noear
 * @since 1.0
 * */
public interface VarHolder {
    /**
     * 应用上下文
     * */
    AppContext context();

    /**
     * 泛型（可能为 null）
     * */
    @Nullable
    ParameterizedType getGenericType();

    /**
     * 是否为字段
     * */
    boolean isField();

    /**
     * 类型
     */
    Class<?> getType();

    /**
     * 注解
     */
    Annotation[] getAnnoS();

    /**
     * 获取完整名字
     * */
    String getFullName();

    /**
     * 设置值
     */
    void setValue(Object val);

    /**
     * 获取值
     * */
    Object getValue();

    /**
     * 是否为完成的（设置值后即为完成态）
     * */
    boolean isDone();

    /**
     * 是否必须
     * */
    boolean required();

    /**
     * 设定必须
     * */
    void required(boolean required);
}
