/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.noear.solon.SolonApp;
import org.noear.solon.SolonProps;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.event.AppPrestopEndEvent;
import org.noear.solon.core.event.AppStopEndEvent;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;

public class Solon {
    private static SolonApp app;
    private static SolonApp appMain;
    private static String encoding;

    public static String version() {
        return "2.7.1-M2";
    }

    public static SolonApp app() {
        return app;
    }

    protected static void appSet(SolonApp solonApp) {
        if (solonApp != null) {
            app = solonApp;
        }
    }

    public static AppContext context() {
        if (app == null) {
            return null;
        }
        return app.context();
    }

    public static SolonProps cfg() {
        return Solon.app().cfg();
    }

    public static String encoding() {
        return encoding;
    }

    public static void encodingSet(String charset) {
        if (app == null && Utils.isNotEmpty(charset)) {
            encoding = charset;
        }
    }

    public static SolonApp start(Class<?> source, String[] args) {
        return Solon.start(source, args, null);
    }

    public static SolonApp start(Class<?> source, String[] args, ConsumerEx<SolonApp> initialize) {
        NvMap argx = NvMap.from(args);
        return Solon.start(source, argx, initialize);
    }

    public static SolonApp start(Class<?> source, NvMap argx, ConsumerEx<SolonApp> initialize) {
        if (appMain != null) {
            app = appMain;
            return appMain;
        }
        if (Utils.isNotEmpty(encoding)) {
            System.setProperty("file.encoding", encoding);
        }
        System.getProperties().putIfAbsent("java.awt.headless", "true");
        RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
        String pid = rb.getName().split("@")[0];
        System.setProperty("PID", pid);
        AppClassLoader.bindingThread();
        try {
            app = appMain = new SolonApp(source, argx);
            LogUtil.global().info("App: Start loading");
            app.start(initialize);
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            LogUtil.global().error("Solon start failed: " + e.getMessage(), e);
            if (NativeDetector.isNotAotRuntime()) {
                Solon.stop0(true, 0);
            }
            Solon.stop0(false, 0);
            throw new IllegalStateException("Solon start failed", e);
        }
        if (NativeDetector.isNotAotRuntime()) {
            if (app.cfg().stopSafe()) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, app.cfg().stopDelay())));
            } else {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Solon.stop0(false, 0)));
            }
        }
        if (Utils.isNotEmpty(Solon.cfg().licence())) {
            LogUtil.global().info("SolonEE.Licence: " + Solon.cfg().licence());
        }
        LogUtil.global().info("App: End loading elapsed=" + app.elapsedTimes() + "ms pid=" + pid + " v=" + Solon.version());
        return app;
    }

    public static void stop() {
        Solon.stop(app.cfg().stopDelay());
    }

    public static void stop(int delay) {
        new Thread(() -> Solon.stop0(true, delay)).start();
    }

    public static void stopBlock(boolean exit, int delay) {
        Solon.stop0(exit, delay);
    }

    public static void stopBlock(boolean exit, int delay, int exitStatus) {
        Solon.stop0(exit, delay, exitStatus);
    }

    private static void stop0(boolean exit, int delay) {
        Solon.stop0(exit, delay, 1);
    }

    private static void stop0(boolean exit, int delay, int exitStatus) {
        if (Solon.app() == null) {
            return;
        }
        if (delay > 0) {
            LogUtil.global().info("App: Security to stop: begin...(1.prestop 2.delay 3.stop)");
            Solon.cfg().plugs().forEach(p -> p.prestop());
            Solon.context().prestop();
            EventBus.publishTry(new AppPrestopEndEvent(Solon.app()));
            LogUtil.global().info("App: Security to stop: 1/3 completed");
            int delay1 = (int)((double)delay * 0.3);
            int delay2 = delay - delay1;
            if (delay1 > 0) {
                Solon.sleep0(delay1);
            }
            Solon.app().stopped = true;
            if (delay2 > 0) {
                Solon.sleep0(delay2);
            }
            LogUtil.global().info("App: Security to stop: 2/3 completed");
            Solon.cfg().plugs().forEach(p -> p.stop());
            Solon.context().stop();
            EventBus.publishTry(new AppStopEndEvent(Solon.app()));
            LogUtil.global().info("App: Security to stop: 3/3 completed");
        } else {
            Solon.cfg().plugs().forEach(p -> p.prestop());
            Solon.context().prestop();
            EventBus.publishTry(new AppPrestopEndEvent(Solon.app()));
            Solon.app().stopped = true;
            Solon.cfg().plugs().forEach(p -> p.stop());
            Solon.context().stop();
            EventBus.publishTry(new AppStopEndEvent(Solon.app()));
        }
        app = null;
        appMain = null;
        if (exit) {
            System.exit(exitStatus);
        }
    }

    private static void sleep0(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        encoding = "utf-8";
    }
}

