/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.noear.solon.core.aspect.Invocation;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;

public class TmplUtil {
    private static final Pattern tmpPattern = Pattern.compile("\\$\\{(\\w*\\.?\\w+)\\}");

    public static String parse(String tmpl, Invocation inv) {
        if (tmpl.indexOf(36) < 0) {
            return tmpl;
        }
        return TmplUtil.parse(tmpl, inv.argsAsMap());
    }

    public static String parse(String tmpl, Invocation inv, Object rst) {
        if (tmpl.indexOf(36) < 0) {
            return tmpl;
        }
        HashMap<String, Object> model = new HashMap<String, Object>(inv.argsAsMap());
        model.put("", rst);
        return TmplUtil.parse(tmpl, model);
    }

    public static String parse(String view, Map<String, Object> model) {
        if (view.indexOf(36) < 0) {
            return view;
        }
        StringBuilder str2 = new StringBuilder(view);
        Matcher m = tmpPattern.matcher(view);
        while (m.find()) {
            String mark = m.group(0);
            String name = m.group(1);
            if (model.containsKey(name)) {
                String val = String.valueOf(model.get(name));
                int idx = str2.indexOf(mark);
                str2 = str2.replace(idx, idx + mark.length(), val);
                continue;
            }
            if (name.indexOf(46) >= 0) {
                String fieldKey = null;
                String fieldVal = null;
                String[] cf = name.split("\\.");
                Object obj = model.get(cf[0]);
                fieldKey = cf[1];
                if (obj != null) {
                    Object valTmp = null;
                    if (obj instanceof Map) {
                        valTmp = ((Map)obj).get(fieldKey);
                    } else {
                        FieldWrap fw = ClassWrap.get(obj.getClass()).getFieldWrap(fieldKey);
                        if (fw == null) {
                            throw new IllegalArgumentException("Missing tmpl parameter (result field): " + name);
                        }
                        try {
                            valTmp = fw.getValue(obj);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (valTmp != null) {
                        fieldVal = valTmp.toString();
                    }
                }
                if (fieldVal == null) {
                    fieldVal = "";
                }
                int idx = str2.indexOf(mark);
                str2 = str2.replace(idx, idx + mark.length(), fieldVal);
                continue;
            }
            throw new IllegalArgumentException("Missing tmpl parameter: " + name);
        }
        return str2.toString();
    }
}

