/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.route;

import org.noear.solon.Solon;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Endpoint;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.route.Router;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.route.RouterInterceptorChain;
import org.noear.solon.lang.Nullable;

public class RouterHandler
implements Handler,
RouterInterceptor {
    private Router router;

    public RouterHandler(Router router) {
        this.router = router;
    }

    @Override
    public void doIntercept(Context ctx, @Nullable Handler mainHandler, RouterInterceptorChain chain) throws Throwable {
        this.handleDo(ctx, mainHandler);
    }

    protected boolean handleMain(Handler h, Context ctx) throws Throwable {
        if (h != null) {
            h.handle(ctx);
            return ctx.status() != 404;
        }
        int code = ctx.attrOrDefault("mainStatus", 404);
        if (code == 405) {
            throw new StatusException("Method Not Allowed: " + ctx.method() + " " + ctx.pathNew(), code);
        }
        throw new StatusException("Not Found: " + ctx.method() + " " + ctx.pathNew(), code);
    }

    protected void handleTriggers(Context ctx, Endpoint endpoint) throws Throwable {
        for (Handler h : this.router.matchMore(ctx, endpoint)) {
            h.handle(ctx);
        }
    }

    private void handleDo(Context x, Handler mainHandler) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        try {
            this.handleTriggers(x, Endpoint.before);
            if (!x.getHandled()) {
                x.setHandled(this.handleMain(mainHandler, x));
            }
        }
        catch (Throwable e) {
            if (x.errors == null) {
                x.errors = e;
            }
            throw e;
        }
        finally {
            this.handleTriggers(x, Endpoint.after);
        }
    }

    @Override
    public void handle(Context x) throws Throwable {
        if (x.getHandled()) {
            return;
        }
        Handler mainHandler = this.router.matchMain(x);
        if (mainHandler instanceof Action) {
            x.attrSet("action", mainHandler);
        }
        Solon.app().chainManager().doIntercept(x, mainHandler);
    }
}

