/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Around;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Component;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Controller;
import org.noear.solon.annotation.Import;
import org.noear.solon.annotation.Inject;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.annotation.PropertySource;
import org.noear.solon.annotation.ProxyComponent;
import org.noear.solon.annotation.Remoting;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanContainer;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanSupplier;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.FactoryManager;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.bean.InitializingBean;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.convert.ConverterFactory;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.handle.ActionExecuteHandler;
import org.noear.solon.core.handle.ActionReturnHandler;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderManager;
import org.noear.solon.core.route.RouterInterceptor;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.BiConsumerEx;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConditionUtil;
import org.noear.solon.core.util.GenericUtil;
import org.noear.solon.core.util.IndexUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.ProxyBinder;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.ScanUtil;
import org.noear.solon.core.wrap.ClassWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.MethodKey;
import org.noear.solon.core.wrap.MethodWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.core.wrap.VarHolderOfParam;

public class AppContext
extends BeanContainer {
    private final Set<RankEntity<LifecycleBean>> lifecycleBeans = new HashSet<RankEntity<LifecycleBean>>();
    private final Map<MethodKey, MethodWrap> methodCached = new HashMap<MethodKey, MethodWrap>();
    private final Set<InjectGather> gatherSet = new HashSet<InjectGather>();
    private final Set<Class<?>> beanCreatedCached = new HashSet();
    private boolean started;

    public AppContext(ClassLoader classLoader, Props props) {
        super(classLoader, props);
        this.initialize();
        this.lifecycle(-96, () -> this.startInjectReview(true));
    }

    public <T> AppContext onEvent(Class<T> type, EventListener<T> handler) {
        EventBus.subscribe(type, handler);
        return this;
    }

    public <T> AppContext onEvent(Class<T> type, int index, EventListener<T> handler) {
        EventBus.subscribe(type, index, handler);
        return this;
    }

    public MethodWrap methodGet(Method method) {
        return this.methodGet(method.getDeclaringClass(), method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodWrap methodGet(Class<?> clz, Method method) {
        MethodKey methodKey = new MethodKey(method, clz);
        MethodWrap mw = this.methodCached.get(methodKey);
        if (mw == null) {
            this.SYNC_LOCK.lock();
            try {
                mw = this.methodCached.get(methodKey);
                if (mw == null) {
                    mw = new MethodWrap(this, clz, method);
                    this.methodCached.put(methodKey, mw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return mw;
    }

    public void methodForeach(Consumer<MethodWrap> action) {
        this.methodCached.values().forEach(action);
    }

    @Override
    public void clear() {
        super.clear();
        this.methodCached.clear();
        this.beanCreatedCached.clear();
        this.gatherSet.clear();
        this.lifecycleBeans.clear();
        this.started = false;
    }

    @Override
    protected BeanWrap wrapCreate(Class<?> type, Object bean, String name) {
        return new BeanWrap(this, type, bean, name);
    }

    protected void initialize() {
        this.beanBuilderAdd(Configuration.class, (clz, bw, anno) -> {
            this.cfg().loadAdd(clz.getAnnotation(PropertySource.class));
            for (Annotation a1 : clz.getAnnotations()) {
                if (a1 instanceof Import) {
                    this.cfg().loadAdd((Import)a1);
                    this.beanImport((Import)a1);
                    continue;
                }
                if ((a1 = a1.annotationType().getAnnotation(Import.class)) == null) continue;
                this.cfg().loadAdd((Import)a1);
                this.beanImport((Import)a1);
            }
            this.beanInjectProperties(clz, bw.raw());
            for (Method m : ClassWrap.get(bw.clz()).getDeclaredMethods()) {
                Bean ma = m.getAnnotation(Bean.class);
                if (ma == null) continue;
                this.tryCreateBeanOfMethod(bw, m, ma);
            }
            this.beanShapeRegister(clz, bw, clz);
            this.beanRegisterSup0(bw);
        });
        this.beanBuilderAdd(Component.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.beanComponentized(bw, anno.registered());
        });
        this.beanBuilderAdd(ProxyComponent.class, (clz, bw, anno) -> {
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            bw.nameSet(beanName);
            bw.tagSet(anno.tag());
            bw.typedSet(anno.typed());
            bw.indexSet(anno.index());
            this.beanComponentized(bw, true);
            LogUtil.global().error("@ProxyComponent will be discarded, suggested use '@Component'");
        });
        this.beanBuilderAdd(Remoting.class, (clz, bw, anno) -> {
            bw.remotingSet(true);
            this.beanRegister(bw, "", false);
        });
        this.beanBuilderAdd(Controller.class, (clz, bw, anno) -> Solon.app().router().add(bw));
        this.beanInjectorAdd(Inject.class, (varH, anno) -> this.beanInject(varH, anno.value(), anno.required(), anno.autoRefreshed()));
    }

    protected void beanComponentized(BeanWrap bw, boolean registered) {
        this.beanExtractOrProxy(bw);
        if (registered) {
            this.beanShapeRegister(bw.clz(), bw, bw.clz());
        }
        this.beanRegister(bw, bw.name(), bw.typed());
        if (bw.singleton()) {
            EventBus.publish(bw.raw());
            this.wrapPublish(bw);
        }
    }

    @Override
    protected void beanInject(VarHolder varH, String name, boolean required, boolean autoRefreshed) {
        super.beanInject(varH, name, required, autoRefreshed);
        if (varH.isDone()) {
            return;
        }
        if (Utils.isEmpty(name) && varH.getGenericType() != null) {
            if (List.class == varH.getType()) {
                Type type;
                Type type0 = varH.getGenericType().getActualTypeArguments()[0];
                if (type0 instanceof ParameterizedType) {
                    type0 = ((ParameterizedType)type0).getRawType();
                }
                if ((type = type0) instanceof Class) {
                    if (varH.isField()) {
                        varH.required(required);
                        this.lifecycle(-95, () -> {
                            if (varH.isDone()) {
                                return;
                            }
                            BeanSupplier beanListSupplier = () -> this.getBeansOfType((Class)type);
                            varH.setValue(beanListSupplier);
                        });
                    } else {
                        varH.required(false);
                        varH.setDependencyType((Class)type);
                        BeanSupplier beanListSupplier = () -> this.getBeansOfType((Class)type);
                        varH.setValueOnly(beanListSupplier);
                    }
                    return;
                }
            }
            if (Map.class == varH.getType()) {
                Type keyType = varH.getGenericType().getActualTypeArguments()[0];
                Type valType0 = varH.getGenericType().getActualTypeArguments()[1];
                if (valType0 instanceof ParameterizedType) {
                    valType0 = ((ParameterizedType)valType0).getRawType();
                }
                Type valType = valType0;
                if (String.class == keyType && valType instanceof Class) {
                    if (varH.isField()) {
                        varH.required(required);
                        this.lifecycle(-95, () -> {
                            if (varH.isDone()) {
                                return;
                            }
                            BeanSupplier beanMapSupplier = () -> this.getBeansMapOfType((Class)valType);
                            varH.setValue(beanMapSupplier);
                        });
                    } else {
                        varH.required(false);
                        varH.setDependencyType((Class)valType);
                        BeanSupplier beanMapSupplier = () -> this.getBeansMapOfType((Class)valType);
                        varH.setValueOnly(beanMapSupplier);
                    }
                    return;
                }
            }
        }
    }

    public void beanShapeRegister(Class<?> clz, BeanWrap bw, AnnotatedElement annoEl) {
        Mapping mapping;
        if (bw.raw() == null) {
            return;
        }
        if (bw.raw() instanceof Plugin) {
            Solon.app().plug((Plugin)bw.raw());
            LogUtil.global().error("'Plugin' will be deprecated as a component, please use 'LifecycleBean'");
            return;
        }
        if (bw.raw() instanceof LifecycleBean) {
            int index = bw.index();
            if (index == 0) {
                index = IndexUtil.buildLifecycleIndex(bw.rawClz());
            }
            this.lifecycle(index + 1, (LifecycleBean)bw.raw());
        }
        if (bw.raw() instanceof EventListener) {
            this.addEventListener(clz, bw);
        }
        if (bw.raw() instanceof LoadBalance.Factory) {
            Solon.app().factoryManager().loadBalanceFactory((LoadBalance.Factory)bw.raw());
        }
        if (bw.raw() instanceof Handler && (mapping = annoEl.getAnnotation(Mapping.class)) != null) {
            Handler handler = (Handler)bw.raw();
            Set<MethodType> v0 = FactoryManager.getGlobal().mvcFactory().findMethodTypes(new HashSet<MethodType>(), t -> annoEl.getAnnotation(t) != null);
            if (v0.size() == 0) {
                v0 = new HashSet<MethodType>(Arrays.asList(mapping.method()));
            }
            Solon.app().add(mapping, v0, handler);
        }
        if (bw.raw() instanceof Render) {
            RenderManager.mapping(bw.name(), (Render)bw.raw());
        }
        if (bw.raw() instanceof Filter) {
            Solon.app().filter(bw.index(), (Filter)bw.raw());
        }
        if (bw.raw() instanceof RouterInterceptor) {
            Solon.app().routerInterceptor(bw.index(), (RouterInterceptor)bw.raw());
        }
        if (bw.raw() instanceof ActionReturnHandler) {
            Solon.app().chainManager().addReturnHandler((ActionReturnHandler)bw.raw());
        }
        if (bw.raw() instanceof ActionExecuteHandler) {
            Solon.app().chainManager().addExecuteHandler((ActionExecuteHandler)bw.raw());
        }
        if (bw.raw() instanceof Converter) {
            Converter c = (Converter)bw.raw();
            Solon.app().converterManager().register(c);
        }
        if (bw.raw() instanceof ConverterFactory) {
            ConverterFactory cf = (ConverterFactory)bw.raw();
            Solon.app().converterManager().register(cf);
        }
    }

    private void addEventListener(Class<?> clz, BeanWrap bw) {
        Class<?>[] ets = GenericUtil.resolveTypeArguments(clz, EventListener.class);
        if (ets != null && ets.length > 0) {
            EventBus.subscribe(ets[0], bw.index(), (EventListener)bw.raw());
        }
    }

    public void beanExtractOrProxy(BeanWrap bw) {
        if (bw == null) {
            return;
        }
        boolean enableProxy = false;
        if (this.beanExtractors.size() > 0 || this.beanInterceptors.size() > 0) {
            ClassWrap clzWrap = ClassWrap.get(bw.clz());
            Method[] methodArray = clzWrap.getMethods();
            int n = methodArray.length;
            for (int i = 0; i < n; ++i) {
                Method m = methodArray[i];
                for (Annotation a : m.getAnnotations()) {
                    BeanExtractor be = (BeanExtractor)this.beanExtractors.get(a.annotationType());
                    if (be != null) {
                        try {
                            be.doExtract(bw, m, a);
                        }
                        catch (Throwable e) {
                            e = Utils.throwableUnwrap(e);
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                    }
                    enableProxy = enableProxy || this.requiredProxy(a);
                }
            }
        }
        if (!enableProxy) {
            for (Annotation a : bw.clz().getAnnotations()) {
                enableProxy = enableProxy || this.requiredProxy(a);
            }
        }
        if (enableProxy) {
            ProxyBinder.global().binding(bw);
        }
    }

    private boolean requiredProxy(Annotation a) {
        return this.beanInterceptors.containsKey(a.annotationType()) || a.annotationType().isAnnotationPresent(Around.class) || a.annotationType().equals(Around.class);
    }

    public void beanInject(Object obj) {
        block7: {
            ArrayList<FieldWrap> fwList;
            ClassWrap clzWrap;
            block6: {
                if (obj == null) {
                    return;
                }
                clzWrap = ClassWrap.get(obj.getClass());
                fwList = new ArrayList<FieldWrap>();
                for (Map.Entry<String, FieldWrap> kv : clzWrap.getFieldWraps().entrySet()) {
                    Annotation[] annS = kv.getValue().annoS;
                    if (annS.length <= 0) continue;
                    fwList.add(kv.getValue());
                }
                if (!(obj instanceof InitializingBean)) break block6;
                InitializingBean initBean = (InitializingBean)obj;
                if (fwList.size() == 0) {
                    RunUtil.runOrThrow(initBean::afterInjection);
                } else {
                    InjectGather gather = new InjectGather(false, clzWrap.clz(), true, fwList.size(), args2 -> RunUtil.runOrThrow(initBean::afterInjection));
                    this.gatherSet.add(gather);
                    for (FieldWrap fw : fwList) {
                        VarHolder varH = fw.holder(this, obj, gather);
                        gather.add(varH);
                        this.tryInject(varH, fw.annoS);
                    }
                }
                break block7;
            }
            if (fwList.size() == 0) break block7;
            InjectGather gather = new InjectGather(false, clzWrap.clz(), true, fwList.size(), null);
            this.gatherSet.add(gather);
            for (FieldWrap fw : fwList) {
                VarHolder varH = fw.holder(this, obj, gather);
                gather.add(varH);
                this.tryInject(varH, fw.annoS);
            }
        }
    }

    public void beanImport(Import anno) {
        if (anno != null) {
            for (Class<?> clz : anno.value()) {
                this.beanMake(clz);
            }
            for (Class<?> clz : anno.classes()) {
                this.beanMake(clz);
            }
            for (String pkg : anno.scanPackages()) {
                this.beanScan(pkg);
            }
            for (Class<?> src : anno.scanPackageClasses()) {
                this.beanScan(src);
            }
        }
    }

    public void beanScan(Class<?> source) {
        if (source.getPackage() != null) {
            this.beanScan(source.getClassLoader(), source.getPackage().getName());
        }
    }

    public void beanScan(String basePackage) {
        this.beanScan(this.getClassLoader(), basePackage);
    }

    public void beanScan(ClassLoader classLoader, String basePackage) {
        if (Utils.isEmpty(basePackage)) {
            return;
        }
        if (classLoader == null) {
            return;
        }
        String dir = basePackage.replace('.', '/');
        ScanUtil.scan(classLoader, dir, n -> n.endsWith(".class")).stream().sorted(Comparator.comparing(s -> s.length())).forEach(name -> {
            String className = name.substring(0, name.length() - 6);
            Class<?> clz = ClassUtil.loadClass(classLoader, className = className.replace('/', '.'));
            if (clz != null) {
                this.tryCreateBeanOfClass(clz);
            }
        });
    }

    public BeanWrap beanMake(Class<?> clz) {
        if (!ConditionUtil.test(this, clz)) {
            return null;
        }
        BeanWrap bw = this.wrap(clz, null);
        this.tryCreateBean0(bw.clz(), (bb, a) -> bb.doBuild(bw.clz(), bw, a));
        this.putWrap(clz, bw);
        return bw;
    }

    protected void tryInject(VarHolder varH, Annotation[] annS) {
        for (Annotation a : annS) {
            BeanInjector bi = (BeanInjector)this.beanInjectors.get(a.annotationType());
            if (bi == null) continue;
            bi.doInject(varH, a);
            return;
        }
        varH.setValue(null);
    }

    protected void tryCreateBeanOfMethod(BeanWrap bw, Method m, Bean ma) throws Throwable {
        if (NativeDetector.isAotRuntime()) {
            this.methodGet(bw.rawClz(), m);
        }
        Condition mc = m.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissing(mc)) {
            this.lifecycle(-98, () -> this.tryCreateBeanOfMethod0(bw, m, ma, mc));
        } else {
            this.tryCreateBeanOfMethod0(bw, m, ma, mc);
        }
    }

    private void tryCreateBeanOfMethod0(BeanWrap bw, Method m, Bean ma, Condition mc) throws Throwable {
        if (!ConditionUtil.test(this, mc)) {
            return;
        }
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        MethodWrap mWrap = this.methodGet(bw.rawClz(), m);
        this.tryBuildBeanOfMethod(ma, mWrap, bw);
    }

    protected void tryCreateBeanOfClass(Class<?> clz) {
        Condition cc = clz.getAnnotation(Condition.class);
        if (!this.started && ConditionUtil.ifMissing(cc)) {
            this.lifecycle(-99, () -> this.tryCreateBeanOfClass0(clz, cc));
        } else {
            this.tryCreateBeanOfClass0(clz, cc);
        }
    }

    private void tryCreateBeanOfClass0(Class<?> clz, Condition cc) {
        if (!ConditionUtil.test(this, cc)) {
            return;
        }
        this.tryCreateBean0(clz, (bb, a) -> {
            BeanWrap bw = this.wrap(clz);
            bb.doBuild(clz, bw, a);
            this.putWrap(clz, bw);
        });
    }

    private void tryCreateBean0(Class<?> clz, BiConsumerEx<BeanBuilder, Annotation> consumer) {
        Annotation[] annS = clz.getAnnotations();
        if (annS.length > 0) {
            if (this.beanCreatedCached.contains(clz)) {
                return;
            }
            this.beanCreatedCached.add(clz);
            for (Annotation a : annS) {
                BeanBuilder builder = (BeanBuilder)this.beanBuilders.get(a.annotationType());
                if (builder == null) continue;
                try {
                    consumer.accept(builder, a);
                }
                catch (Throwable e) {
                    e = Utils.throwableUnwrap(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    protected void tryBuildBeanOfMethod(Bean anno, MethodWrap mWrap, BeanWrap bw) throws Throwable {
        int size2 = mWrap.getParamWraps().length;
        if (size2 == 0) {
            this.tryBuildBeanOfMethodDo(anno, mWrap, bw, new Object[0]);
        } else {
            InjectGather gather = new InjectGather(true, mWrap.getReturnType(), true, size2, args2 -> RunUtil.runOrThrow(() -> this.tryBuildBeanOfMethodDo(anno, mWrap, bw, (Object[])args2)));
            this.gatherSet.add(gather);
            for (ParamWrap pw : mWrap.getParamWraps()) {
                VarHolderOfParam varH = new VarHolderOfParam(bw.context(), pw.getParameter(), gather);
                gather.add(varH);
                Annotation[] annoS = pw.getParameter().getAnnotations();
                if (annoS.length == 0) {
                    this.beanInject(varH, null, true, false);
                    continue;
                }
                this.tryInject(varH, annoS);
            }
        }
    }

    protected void tryBuildBeanOfMethodDo(Bean anno, MethodWrap mWrap, BeanWrap bw, Object[] args) throws Throwable {
        Object raw = mWrap.invoke(bw.raw(), args);
        if (raw != null) {
            Class<?> beanClz = mWrap.getReturnType();
            Type beanGtp = mWrap.getGenericReturnType();
            BeanWrap m_bw = null;
            if (raw instanceof BeanWrap) {
                m_bw = (BeanWrap)raw;
            } else {
                if (anno.injected()) {
                    this.beanInject(raw);
                }
                EventBus.publish(raw);
                m_bw = new BeanWrap(this, beanClz, raw, null, false, anno.initMethod(), anno.destroyMethod());
            }
            String beanName = Utils.annoAlias(anno.value(), anno.name());
            m_bw.nameSet(beanName);
            m_bw.tagSet(anno.tag());
            m_bw.typedSet(anno.typed());
            m_bw.indexSet(anno.index());
            if (anno.registered()) {
                this.beanShapeRegister(m_bw.clz(), m_bw, mWrap.getMethod());
            }
            this.beanRegister(m_bw, beanName, anno.typed());
            if (beanGtp instanceof ParameterizedType) {
                this.putWrap(beanGtp.getTypeName(), m_bw);
            }
            this.wrapPublish(m_bw);
        }
    }

    @Deprecated
    public void beanOnloaded(Consumer<AppContext> fun) {
        this.beanOnloaded(-1, fun::accept);
    }

    @Deprecated
    public void beanOnloaded(int index, Consumer<AppContext> fun) {
        try {
            this.lifecycle(index, () -> fun.accept(this));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public void beanLoaded() {
        this.start();
    }

    @Override
    public void lifecycle(LifecycleBean lifecycle) {
        this.lifecycle(0, lifecycle);
    }

    @Override
    public void lifecycle(int index, LifecycleBean lifecycle) {
        this.lifecycleBeans.add(new RankEntity<LifecycleBean>(lifecycle, index));
        if (this.started) {
            RunUtil.runOrThrow(lifecycle::start);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        this.started = true;
        try {
            this.startBeanLifecycle();
            this.startInjectReview(false);
        }
        catch (Throwable e) {
            throw new IllegalStateException("AppContext start failed", e);
        }
    }

    private void startBeanLifecycle() throws Throwable {
        ArrayList<RankEntity<LifecycleBean>> beans = new ArrayList<RankEntity<LifecycleBean>>(this.lifecycleBeans);
        beans.sort(Comparator.comparingInt(f -> f.index));
        for (RankEntity rankEntity : beans) {
            ((LifecycleBean)rankEntity.target).start();
        }
    }

    private void startInjectReview(boolean onlyMethod) throws Throwable {
        List<InjectGather> gatherList = null;
        gatherList = onlyMethod ? this.gatherSet.stream().filter(g1 -> !g1.isDone() && g1.isMethod()).collect(Collectors.toList()) : this.gatherSet.stream().filter(g1 -> !g1.isDone()).collect(Collectors.toList());
        if (gatherList.size() > 0) {
            for (InjectGather gather : gatherList) {
                IndexUtil.buildGatherIndex(gather, gatherList);
            }
            gatherList.sort(Comparator.comparingInt(g1 -> g1.index));
            for (InjectGather g12 : gatherList) {
                g12.check();
            }
        }
    }

    public void prestop() {
        this.started = false;
        try {
            ArrayList<RankEntity<LifecycleBean>> beans = new ArrayList<RankEntity<LifecycleBean>>(this.lifecycleBeans);
            beans.sort(Comparator.comparingInt(f -> f.index));
            for (RankEntity rankEntity : beans) {
                try {
                    ((LifecycleBean)rankEntity.target).prestop();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable ignored) {
            LogUtil.global().warn("AppContext prestop error", ignored);
        }
    }

    public void stop() {
        this.started = false;
        try {
            ArrayList<RankEntity<LifecycleBean>> beans = new ArrayList<RankEntity<LifecycleBean>>(this.lifecycleBeans);
            beans.sort(Comparator.comparingInt(f -> f.index));
            for (RankEntity rankEntity : beans) {
                try {
                    ((LifecycleBean)rankEntity.target).stop();
                }
                catch (Throwable throwable) {}
            }
            this.beanStop0();
        }
        catch (Throwable ignored) {
            LogUtil.global().warn("AppContext stop error", ignored);
        }
    }
}

