/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.noear.solon.Solon;

public class DateUtil {
    private static final String FORMAT_29 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private static final String FORMAT_25 = "yyyy-MM-dd'T'HH:mm:ss+HH:mm";
    private static final String FORMAT_24_ISO08601 = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String FORMAT_23_a = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final String FORMAT_23_b = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String FORMAT_22 = "yyyyMMddHHmmssSSSZ";
    private static final String FORMAT_19_ISO = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String FORMAT_19_a = "yyyy-MM-dd HH:mm:ss";
    private static final String FORMAT_19_b = "yyyy/MM/dd HH:mm:ss";
    private static final String FORMAT_19_c = "yyyy.MM.dd HH:mm:ss";
    private static final String FORMAT_17 = "yyyyMMddHHmmssSSS";
    private static final String FORMAT_16_a = "yyyy-MM-dd HH:mm";
    private static final String FORMAT_16_b = "yyyy/MM/dd HH:mm";
    private static final String FORMAT_16_c = "yyyy.MM.dd HH:mm";
    private static final String FORMAT_14 = "yyyyMMddHHmmss";
    private static final String FORMAT_10_a = "yyyy-MM-dd";
    private static final String FORMAT_10_b = "yyyy/MM/dd";
    private static final String FORMAT_10_c = "yyyy.MM.dd";
    private static final String FORMAT_9 = "HH\u65f6mm\u5206ss\u79d2";
    private static final String FORMAT_8_a = "HH:mm:ss";
    private static final String FORMAT_8_b = "yyyyMMdd";

    public static Date parse(String val) throws ParseException {
        char c1;
        int len = val.length();
        String ft = null;
        if (len == 29) {
            if (val.charAt(26) == ':' && val.charAt(28) == '0') {
                ft = FORMAT_29;
            }
        } else if (len == 25) {
            ft = FORMAT_25;
        } else if (len == 24) {
            if (val.charAt(10) == 'T') {
                ft = FORMAT_24_ISO08601;
            }
        } else if (len == 23) {
            ft = val.charAt(19) == ',' ? FORMAT_23_a : FORMAT_23_b;
        } else if (len == 22) {
            ft = FORMAT_22;
        } else if (len == 19) {
            ft = val.charAt(10) == 'T' ? FORMAT_19_ISO : ((c1 = val.charAt(4)) == '/' ? FORMAT_19_b : (c1 == '.' ? FORMAT_19_c : FORMAT_19_a));
        } else if (len == 17) {
            ft = FORMAT_17;
        } else if (len == 16) {
            c1 = val.charAt(4);
            ft = c1 == '/' ? FORMAT_16_b : (c1 == '.' ? FORMAT_16_c : FORMAT_16_a);
        } else if (len == 14) {
            ft = FORMAT_14;
        } else if (len == 10) {
            c1 = val.charAt(4);
            if (c1 == '/') {
                ft = FORMAT_10_b;
            } else if (c1 == '.') {
                ft = FORMAT_10_c;
            } else if (c1 == '-') {
                ft = FORMAT_10_a;
            }
        } else if (len == 9) {
            c1 = val.charAt(4);
            ft = c1 == '/' ? FORMAT_10_b : (c1 == '.' ? FORMAT_10_c : (c1 == '-' ? FORMAT_10_a : FORMAT_9));
        } else if (len == 8) {
            c1 = val.charAt(4);
            ft = c1 == '/' ? FORMAT_10_b : (c1 == '.' ? FORMAT_10_c : (c1 == '-' ? FORMAT_10_a : (val.charAt(2) == ':' ? FORMAT_8_a : FORMAT_8_b)));
        }
        if (ft != null) {
            SimpleDateFormat df = null;
            df = Solon.app() == null ? new SimpleDateFormat(ft) : new SimpleDateFormat(ft, Solon.cfg().locale());
            df.setTimeZone(TimeZone.getDefault());
            return df.parse(val);
        }
        return null;
    }

    public static String toGmtString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }
}

