/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.exception.ConstructionException;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.util.SupplierEx;

public class ClassUtil {
    private static final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    public static boolean hasClass(SupplierEx<Class<?>> test) {
        try {
            test.get();
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public static Class<?> loadClass(String className) {
        return ClassUtil.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            if (classLoader == null) {
                return Class.forName(className);
            }
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    public static <T> T tryInstance(String className) {
        return ClassUtil.tryInstance(className, null);
    }

    public static <T> T tryInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(AppClassLoader.global(), className, prop);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className, null);
    }

    public static <T> T tryInstance(ClassLoader classLoader, String className, Properties prop) {
        Class<?> clz = ClassUtil.loadClass(classLoader, className);
        return ClassUtil.tryInstance(clz, prop);
    }

    public static <T> T tryInstance(Class<?> clz, Properties prop) {
        if (clz == null) {
            return null;
        }
        try {
            return ClassUtil.newInstance(clz, prop);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T newInstance(Class<?> clz) throws ConstructionException {
        return ClassUtil.newInstance(clz, null);
    }

    public static <T> T newInstance(Class<?> clz, Properties prop) throws ConstructionException {
        try {
            if (prop == null) {
                return (T)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (T)clz.getConstructor(Properties.class).newInstance(prop);
        }
        catch (Exception e) {
            throw new ConstructionException(e);
        }
    }

    public static Object newInstance(Constructor constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConstructionException(e);
        }
    }

    @Deprecated
    public static <T> T newInstance(String className) {
        return ClassUtil.tryInstance(className);
    }

    @Deprecated
    public static <T> T newInstance(String className, Properties prop) {
        return ClassUtil.tryInstance(className, prop);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className) {
        return ClassUtil.tryInstance(classLoader, className);
    }

    @Deprecated
    public static <T> T newInstance(ClassLoader classLoader, String className, Properties prop) {
        return ClassUtil.tryInstance(classLoader, className, prop);
    }

    public static ClassLoader resolveClassLoader(Type type) {
        ClassLoader cl;
        Class<?> clz;
        ClassLoader loader = AppClassLoader.global();
        if (type != null && (clz = ClassUtil.getTypeClass(type)) != Object.class && (cl = clz.getClassLoader()) != systemClassLoader) {
            loader = cl;
        }
        return loader;
    }

    public static Class<?> getTypeClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getTypeClass(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Collection<Method> findPublicMethods(Class<?> clz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m1 : ReflectUtil.getDeclaredMethods(clz)) {
            if (Modifier.isPublic(m1.getModifiers())) continue;
            methods.add(m1);
        }
        for (Method m1 : ReflectUtil.getMethods(clz)) {
            methods.add(m1);
        }
        return methods;
    }
}

