/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.FileBase;

public class DownloadedFile
extends FileBase
implements Closeable {
    private boolean attachment = true;
    private int maxAgeSeconds = 0;
    private String eTag = null;
    private Date lastModified;
    private File file;

    public boolean isAttachment() {
        return this.attachment;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public String getETag() {
        return this.eTag;
    }

    public Date getLastModified() {
        if (this.lastModified == null) {
            return new Date();
        }
        return this.lastModified;
    }

    public DownloadedFile asAttachment(boolean attachment) {
        this.attachment = attachment;
        return this;
    }

    public DownloadedFile cacheControl(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
        return this;
    }

    public DownloadedFile eTag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public DownloadedFile lastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public InputStream getContent() throws IOException {
        if (this.content == null) {
            this.content = new FileInputStream(this.file);
        }
        return this.content;
    }

    public long getContentSize() throws IOException {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        return this.getContent().available();
    }

    @Override
    public void close() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }

    public DownloadedFile(String contentType, long contentSize, InputStream content, String name) {
        super(contentType, contentSize, content, name);
    }

    public DownloadedFile(String contentType, InputStream content, String name) {
        super(contentType, 0L, content, name);
    }

    public DownloadedFile(String contentType, byte[] content, String name) {
        super(contentType, content.length, new ByteArrayInputStream(content), name);
    }

    public DownloadedFile(File file) throws FileNotFoundException {
        this(file, file.getName());
    }

    public DownloadedFile(File file, String name) throws FileNotFoundException {
        this(file, name, Utils.mime(file.getName()));
    }

    public DownloadedFile(File file, String name, String contentType) throws FileNotFoundException {
        super(contentType, file.length(), null, name);
        this.file = file;
        this.lastModified(new Date(file.lastModified()));
    }
}

