/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.core;

import java.lang.annotation.Annotation;

/**
 * Bean 构建器（此类用于扩展AppContext，为其添加构建器）
 *
 * <pre><code>
 * //@Cron4j 构建器添加
 * context.beanBuilderAdd(Cron4j.classs, (clz, bw, anno)->{
 *     ...
 * });
 *
 * //@Cron4j demo
 * @Cron4j(cronx = "*\/1 * * * *")
 * public class DemoJob implements Task{
 *     @Db("db1")
 *     UserMapper userMapper;
 *
 *     public void execute(TaskExecutionContext context) throws RuntimeException{
 *         ...
 *     }
 * }
 * </code></pre>
 *
 * @author noear
 * @since 1.0
 * */
@FunctionalInterface
public interface BeanBuilder<T extends Annotation> {
    /**
     * 构建
     *
     * @param clz 类
     * @param anno 注解
     * */
    void doBuild(Class<?> clz, BeanWrap bw, T anno) throws Throwable;
}
