/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.core.util.NameUtil;
import org.noear.solon.core.wrap.FieldWrapSpec;
import org.noear.solon.core.wrap.TypeWrap;
import org.noear.solon.core.wrap.VarHolderOfField;
import org.noear.solon.core.wrap.VarSpec;
import org.noear.solon.lang.Nullable;

public class FieldWrap {
    private final Class<?> ownerClz;
    private final Field field;
    private final boolean isFinal;
    private final boolean isStatic;
    private Method _setter;
    private Method _getter;
    private Annotation[] annoS;
    private VarSpec __spec;
    private TypeWrap typeWrap;

    protected FieldWrap(Class<?> clz, Field f1) {
        this.ownerClz = clz;
        this.field = f1;
        this.isFinal = Modifier.isFinal(f1.getModifiers());
        this.isStatic = Modifier.isStatic(f1.getModifiers());
        if (!this.isStatic) {
            this._setter = FieldWrap.doFindSetter(clz, f1);
            this._getter = FieldWrap.doFindGetter(clz, f1);
        }
    }

    public VarSpec spec() {
        if (this.__spec == null) {
            this.__spec = new FieldWrapSpec(this);
        }
        return this.__spec;
    }

    public Class<?> getOwnerClz() {
        return this.ownerClz;
    }

    public String getName() {
        return this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    private TypeWrap getTypeWrap() {
        if (this.typeWrap == null) {
            this.typeWrap = new TypeWrap(this.ownerClz, this.field.getType(), this.field.getGenericType());
            if (this.typeWrap.isInvalid()) {
                throw new IllegalStateException("Field generic analysis failed: " + this.field.getDeclaringClass().getName() + "." + this.field.getName());
            }
        }
        return this.typeWrap;
    }

    public Class<?> getType() {
        return this.getTypeWrap().getType();
    }

    @Nullable
    public ParameterizedType getGenericType() {
        return this.getTypeWrap().getGenericType();
    }

    public Annotation[] getAnnoS() {
        if (this.annoS == null) {
            this.annoS = this.field.getAnnotations();
        }
        return this.annoS;
    }

    public VarHolder holder(AppContext ctx, Object obj, InjectGather gather) {
        return new VarHolderOfField(ctx, this, obj, gather);
    }

    public Object getValue(Object tObj) {
        return this.getValue(tObj, false);
    }

    public Object getValue(Object tObj, boolean disFun) {
        if (this.isStatic) {
            tObj = null;
        }
        try {
            if (this._getter == null || disFun) {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                return this.field.get(tObj);
            }
            return this._getter.invoke(tObj, new Object[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setValue(Object tObj, Object val) {
        this.setValue(tObj, val, false);
    }

    public void setValue(Object tObj, Object val, boolean disFun) {
        if (this.isFinal) {
            return;
        }
        if (this.isStatic) {
            tObj = null;
        }
        try {
            if (val == null) {
                return;
            }
            if (this._setter == null || disFun) {
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                this.field.set(tObj, val);
            } else {
                this._setter.invoke(tObj, val);
            }
        }
        catch (IllegalArgumentException ex) {
            if (val == null) {
                throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failur!", ex);
            }
            throw new IllegalArgumentException(this.field.getName() + "(" + this.field.getType().getSimpleName() + ") Type receive failure \uff1aval(" + val.getClass().getSimpleName() + ")", ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Method doFindGetter(Class<?> tCls, Field field) {
        String getterName = NameUtil.getPropGetterName(field.getName());
        try {
            Method getFun = tCls.getMethod(getterName, new Class[0]);
            if (getFun != null) {
                return getFun;
            }
        }
        catch (NoSuchMethodException getFun) {
        }
        catch (SecurityException e) {
            LogUtil.global().warn("FieldWrap doFindGetter failed!", e);
        }
        return null;
    }

    private static Method doFindSetter(Class<?> tCls, Field field) {
        String setterName = NameUtil.getPropSetterName(field.getName());
        try {
            Method setFun = tCls.getMethod(setterName, field.getType());
            if (setFun != null) {
                return setFun;
            }
        }
        catch (NoSuchMethodException setFun) {
        }
        catch (SecurityException e) {
            LogUtil.global().warn("FieldWrap doFindSetter failed!", e);
        }
        return null;
    }
}

