/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.util.ClassUtil;

public class AppClassLoader
extends URLClassLoader {
    private static AppClassLoader global;
    private Map<URL, JarURLConnection> cachedMap = new HashMap<URL, JarURLConnection>();

    public static AppClassLoader global() {
        return global;
    }

    public static void globalSet(AppClassLoader instance) {
        if (instance != null) {
            global = instance;
        }
    }

    public static AppClassLoader loadJar(URL url) {
        AppClassLoader loader = new AppClassLoader();
        loader.addJar(url);
        return loader;
    }

    public static AppClassLoader loadJar(File fileOrDir) {
        AppClassLoader loader = new AppClassLoader();
        loader.addJar(fileOrDir);
        return loader;
    }

    public AppClassLoader() {
        this(Utils.getClassLoader());
    }

    public AppClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public AppClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addJar(URL url) {
        this.addJar(url, true);
    }

    public void addJar(File file) {
        try {
            this.addJar(file.toURI().toURL(), true);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addJar(URL url, boolean useCaches) {
        try {
            URLConnection uc = url.openConnection();
            if (uc instanceof JarURLConnection) {
                JarURLConnection juc = (JarURLConnection)uc;
                juc.setUseCaches(useCaches);
                juc.getManifest();
                this.cachedMap.put(url, juc);
            }
        }
        catch (Throwable ex) {
            System.err.println("Failed to cache plugin JAR file: " + url.toExternalForm());
        }
        this.addURL(url);
    }

    public void removeJar(URL url) {
        JarURLConnection jarURL = this.cachedMap.get(url);
        try {
            if (jarURL != null) {
                jarURL.getJarFile().close();
                this.cachedMap.remove(url);
            }
        }
        catch (Throwable ex) {
            System.err.println("Failed to unload JAR file\n" + ex);
        }
    }

    public void removeJar(File file) {
        try {
            this.removeJar(file.toURI().toURL());
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        for (JarURLConnection jarURL : this.cachedMap.values()) {
            jarURL.getJarFile().close();
        }
        this.cachedMap.clear();
    }

    @Override
    public Class<?> loadClass(String clzName) throws ClassNotFoundException {
        return super.loadClass(clzName);
    }

    public static void bindingThread() {
        Thread.currentThread().setContextClassLoader(AppClassLoader.global());
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = super.getResources(name);
        if (urls == null || !urls.hasMoreElements()) {
            urls = ClassLoader.getSystemResources(name);
        }
        return urls;
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (url == null) {
            url = AppClassLoader.class.getResource(name);
        }
        return url;
    }

    static {
        AppClassLoader tmp = (AppClassLoader)ClassUtil.tryInstance("org.noear.solon.extend.impl.AppClassLoaderExt");
        global = tmp == null ? new AppClassLoader() : tmp;
    }
}

