/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.lang.reflect.AnnotatedElement;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Condition;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.core.util.RunnableEx;

public class ConditionUtil {
    public static boolean ifMissingBean(Condition anno) {
        if (anno == null) {
            return false;
        }
        try {
            return anno.onMissingBean() != Void.class || Utils.isNotEmpty(anno.onMissingBeanName());
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static boolean ifBean(Condition anno) {
        if (anno == null) {
            return false;
        }
        try {
            return anno.onBean() != Void.class || Utils.isNotEmpty(anno.onBeanName());
        }
        catch (Throwable e) {
            return true;
        }
    }

    public static void onBeanRun(Condition anno, AppContext context, RunnableEx runnable) {
        if (anno.onBean() != Void.class) {
            context.getBeanAsync(anno.onBean(), bean -> {
                if (Utils.isNotEmpty(anno.onBeanName())) {
                    context.getBeanAsync(anno.onBeanName(), bean2 -> RunUtil.runOrThrow(() -> runnable.run()));
                } else {
                    RunUtil.runOrThrow(() -> runnable.run());
                }
            });
        } else {
            context.getBeanAsync(anno.onBeanName(), bean -> RunUtil.runOrThrow(() -> runnable.run()));
        }
    }

    public static boolean test(AppContext context, AnnotatedElement element) {
        Condition anno = element.getAnnotation(Condition.class);
        return ConditionUtil.test(context, anno);
    }

    public static boolean test(AppContext context, Condition anno) {
        if (anno == null) {
            return true;
        }
        return !ConditionUtil.testNo(context, anno);
    }

    private static boolean testNo(AppContext context, Condition anno) {
        try {
            anno.onClass();
        }
        catch (Throwable e) {
            return true;
        }
        if (Utils.isNotEmpty(anno.onClassName()) && ClassUtil.loadClass(context.getClassLoader(), anno.onClassName()) == null) {
            return true;
        }
        if (Utils.isNotEmpty(anno.onProperty())) {
            String[] exprs;
            for (String expr : exprs = anno.onProperty().split("&&")) {
                if (!ConditionUtil.testPropertyNo(context, expr.trim())) continue;
                return true;
            }
        }
        try {
            if (anno.onMissingBean() != Void.class && context.hasWrap(anno.onMissingBean())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Utils.isNotEmpty(anno.onMissingBeanName()) && context.hasWrap(anno.onMissingBeanName());
    }

    private static boolean testPropertyNo(AppContext context, String expr) {
        int kIdx = expr.indexOf(61);
        if (kIdx < 0) {
            String val = context.cfg().getByExpr(expr);
            if (!Utils.isNotEmpty(val)) {
                return true;
            }
        } else {
            String right;
            String left;
            boolean isNeq = false;
            if (expr.charAt(kIdx + 1) == '=') {
                left = expr.substring(0, kIdx).trim();
                right = expr.substring(++kIdx + 1, expr.length()).trim();
            } else if (expr.charAt(kIdx - 1) == '!') {
                isNeq = true;
                right = expr.substring(kIdx + 1, expr.length()).trim();
                left = expr.substring(0, --kIdx).trim();
            } else {
                left = expr.substring(0, kIdx).trim();
                right = expr.substring(kIdx + 1, expr.length()).trim();
            }
            String leftV = context.cfg().getByExpr(left);
            if (isNeq ? right.equals(leftV) : !right.equals(leftV)) {
                return true;
            }
        }
        return false;
    }
}

