/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.DownloadedFile;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.handle.RenderFactory;
import org.noear.solon.core.util.DataThrowable;
import org.noear.solon.core.util.LogUtil;

public class RenderManager
implements Render {
    private final Map<String, Render> _mapping = new HashMap<String, Render>();
    private final Map<String, Render> _lib = new HashMap<String, Render>();
    private Render _def = (d, c) -> {
        if (d != null) {
            c.output(d.toString());
        }
    };

    public Render get(String name) {
        Render tmp = this._lib.get(name);
        if (tmp == null) {
            tmp = this._mapping.get(name);
        }
        return tmp;
    }

    public void register(RenderFactory renderFactory) {
        Render render = renderFactory.create();
        for (String mapping : renderFactory.mappings()) {
            this.register(mapping, render);
        }
    }

    public void register(String mapping, Render render) {
        if (render == null) {
            return;
        }
        if (Utils.isEmpty(mapping)) {
            this._def = render;
            this._lib.put(render.getClass().getSimpleName(), render);
            this._lib.put(render.getClass().getName(), render);
            LogUtil.global().info("View: load: " + render.getClass().getSimpleName());
            LogUtil.global().info("View: load: " + render.getClass().getName());
        } else {
            this._mapping.put(mapping, render);
            LogUtil.global().info("Render mapping: " + mapping + "=" + render.name());
        }
    }

    public void register(String mapping, String clzName) {
        if (mapping == null || clzName == null) {
            return;
        }
        Render render = this._lib.get(clzName);
        if (render == null) {
            LogUtil.global().warn("Render: " + clzName + " not exists!");
            return;
        }
        this._mapping.put(mapping, render);
        LogUtil.global().info("Render mapping: " + mapping + "=" + clzName);
    }

    public String renderAndReturn(ModelAndView modelAndView) {
        try {
            return this.renderAndReturn(modelAndView, Context.current());
        }
        catch (Throwable ex) {
            ex = Utils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String renderAndReturn(Object data, Context ctx) throws Throwable {
        Render render;
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (Utils.isNotEmpty(mv.view())) {
                String suffix;
                Render render2;
                int suffix_idx = mv.view().lastIndexOf(".");
                if (suffix_idx > 0 && (render2 = this._mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                    ctx.attrMap().forEach((k, v) -> mv.putIfAbsent((String)k, v));
                    return render2.renderAndReturn(mv, ctx);
                }
                return this._def.renderAndReturn(mv, ctx);
            }
            data = mv.model();
        }
        if ((render = this.resolveRander(ctx)) != null) {
            return render.renderAndReturn(data, ctx);
        }
        return this._def.renderAndReturn(data, ctx);
    }

    @Override
    public void render(Object data, Context ctx) throws Throwable {
        if (data instanceof DataThrowable) {
            return;
        }
        if (data instanceof ModelAndView) {
            ModelAndView mv = (ModelAndView)((Object)data);
            if (!Utils.isEmpty(mv.view())) {
                String suffix;
                Render render;
                int suffix_idx = mv.view().lastIndexOf(".");
                if (suffix_idx > 0 && (render = this._mapping.get(suffix = mv.view().substring(suffix_idx))) != null) {
                    ctx.attrMap().forEach((k, v) -> mv.putIfAbsent((String)k, v));
                    render.render(mv, ctx);
                    return;
                }
                this._def.render(mv, ctx);
                return;
            }
            data = mv.model();
        }
        if (data instanceof File) {
            ctx.outputAsFile((File)((Object)data));
            return;
        }
        if (data instanceof DownloadedFile) {
            ctx.outputAsFile((DownloadedFile)((Object)data));
            return;
        }
        if (data instanceof InputStream) {
            ctx.output((InputStream)((Object)data));
            return;
        }
        Render render = this.resolveRander(ctx);
        if (render != null) {
            render.render(data, ctx);
        } else {
            this._def.render(data, ctx);
        }
    }

    private Render resolveRander(Context ctx) {
        Render render = null;
        String mode = ctx.header("X-Serialization");
        if (Utils.isEmpty(mode)) {
            mode = (String)ctx.attr("@render");
        }
        if (!Utils.isEmpty(mode) && (render = this._mapping.get(mode)) == null) {
            ctx.headerSet("Solon.serialization.mode", "Not supported " + mode);
        }
        if (render == null) {
            String at = ctx.acceptNew();
            for (Render r : this._mapping.values()) {
                if (!r.matched(ctx, at)) continue;
                render = r;
                break;
            }
        }
        if (render == null) {
            render = ctx.remoting() ? this._mapping.get("@type_json") : this._mapping.get("@json");
        }
        return render;
    }
}

