/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.util.NamedThreadFactory;
import org.noear.solon.core.util.ThreadsUtil;

public class RunHolder {
    private ExecutorService asyncExecutor;
    private ScheduledExecutorService scheduledExecutor;

    public ExecutorService getAsyncExecutor() {
        if (this.asyncExecutor == null) {
            Utils.locker().lock();
            try {
                if (this.asyncExecutor == null) {
                    if (Solon.app() != null && Solon.cfg().isEnabledVirtualThreads()) {
                        this.asyncExecutor = ThreadsUtil.newVirtualThreadPerTaskExecutor();
                    } else {
                        int asyncPoolSize = Runtime.getRuntime().availableProcessors() * 2;
                        this.asyncExecutor = new ThreadPoolExecutor(0, asyncPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Solon-executor-").daemon(true));
                    }
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.asyncExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        if (this.scheduledExecutor == null) {
            Utils.locker().lock();
            try {
                if (this.scheduledExecutor == null) {
                    int scheduledPoolSize = Runtime.getRuntime().availableProcessors() * 2;
                    this.scheduledExecutor = new ScheduledThreadPoolExecutor(scheduledPoolSize, new NamedThreadFactory("Solon-scheduledExecutor-"));
                }
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return this.scheduledExecutor;
    }

    public void setScheduledExecutor(ScheduledExecutorService executor) {
        if (executor != null) {
            ScheduledExecutorService old = this.scheduledExecutor;
            this.scheduledExecutor = executor;
            if (old != null) {
                old.shutdown();
            }
        }
    }

    public void setAsyncExecutor(ExecutorService executor) {
        if (executor != null) {
            ExecutorService old = this.asyncExecutor;
            this.asyncExecutor = executor;
            if (old != null) {
                old.shutdown();
            }
        }
    }

    public void shutdown() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor = null;
        }
        if (this.asyncExecutor != null) {
            this.asyncExecutor.shutdown();
            this.asyncExecutor = null;
        }
    }
}

