/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.handle;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.FileBase;
import org.noear.solon.core.util.IoUtil;

public class UploadedFile
extends FileBase {
    private Closeable deleteAction;
    private String extension;

    public String getExtension() {
        return this.extension;
    }

    public InputStream getContent() {
        return this.content;
    }

    public byte[] getContentAsBytes() throws IOException {
        if (this.content == null) {
            return new byte[0];
        }
        return IoUtil.transferToBytes(this.content);
    }

    public long getContentSize() {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        try {
            if (this.content == null) {
                return 0L;
            }
            return this.content.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public UploadedFile() {
    }

    public UploadedFile(File file) throws FileNotFoundException {
        this(file, file.getName());
    }

    public UploadedFile(File file, String name) throws FileNotFoundException {
        this(file, name, Utils.mime(file.getName()));
    }

    public UploadedFile(File file, String name, String contentType) throws FileNotFoundException {
        super(contentType, file.length(), new FileInputStream(file), name);
    }

    public UploadedFile(String contentType, InputStream content, String name) {
        super(contentType, 0L, content, name);
    }

    public UploadedFile(String contentType, long contentSize, InputStream content, String name, String extension) {
        this(null, contentType, contentSize, content, name, extension);
    }

    public UploadedFile(Closeable deleteAction, String contentType, long contentSize, InputStream content, String name, String extension) {
        super(contentType, contentSize, content, name);
        this.extension = extension;
        this.deleteAction = deleteAction;
    }

    public void delete() throws IOException {
        if (this.deleteAction != null) {
            this.deleteAction.close();
        }
    }

    public boolean isEmpty() throws IOException {
        return this.getContentSize() == 0L;
    }

    public void transferTo(File file) throws IOException {
        try (FileOutputStream stream = new FileOutputStream(file);){
            IoUtil.transferTo(this.getContent(), stream);
        }
    }

    public void transferTo(OutputStream stream) throws IOException {
        IoUtil.transferTo(this.getContent(), stream);
    }
}

