/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.noear.solon.Utils;
import org.noear.solon.core.util.RunHolder;
import org.noear.solon.core.util.RunnableEx;

public class RunUtil {
    private static RunHolder runHolder = new RunHolder();

    public static void shutdown() {
        runHolder.shutdown();
    }

    public static void preheat() {
        runHolder.getAsyncExecutor();
        runHolder.getScheduledExecutor();
    }

    @Deprecated
    public static void setParallelExecutor(ExecutorService parallelExecutor) {
    }

    public static void setScheduledExecutor(ScheduledExecutorService scheduledExecutor) {
        runHolder.setScheduledExecutor(scheduledExecutor);
    }

    public static void setAsyncExecutor(ExecutorService asyncExecutor) {
        runHolder.setAsyncExecutor(asyncExecutor);
    }

    public static void runOrThrow(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            e = Utils.throwableUnwrap(e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public static void runAndTry(RunnableEx task) {
        try {
            task.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static <T> T callAndTry(Callable<T> task) {
        try {
            return task.call();
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    @Deprecated
    public static Future<?> parallel(Runnable task) {
        return runHolder.getAsyncExecutor().submit(task);
    }

    @Deprecated
    public static <T> Future<T> parallel(Callable<T> task) {
        return runHolder.getAsyncExecutor().submit(task);
    }

    public static CompletableFuture<Void> async(Runnable task) {
        return CompletableFuture.runAsync(task, runHolder.getAsyncExecutor());
    }

    public static <U> CompletableFuture<U> async(Supplier<U> task) {
        return CompletableFuture.supplyAsync(task, runHolder.getAsyncExecutor());
    }

    public static CompletableFuture<Void> asyncAndTry(RunnableEx task) {
        return CompletableFuture.runAsync(() -> RunUtil.runAndTry(task), runHolder.getAsyncExecutor());
    }

    public static ScheduledFuture<?> delay(Runnable task, long millis) {
        return runHolder.getScheduledExecutor().schedule(task, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> delayAndRepeat(Runnable task, long millis) {
        return runHolder.getScheduledExecutor().scheduleWithFixedDelay(task, 1000L, millis, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long millisPeriod) {
        return runHolder.getScheduledExecutor().scheduleAtFixedRate(task, initialDelay, millisPeriod, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long millisDelay) {
        return runHolder.getScheduledExecutor().scheduleWithFixedDelay(task, initialDelay, millisDelay, TimeUnit.MILLISECONDS);
    }
}

