/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.function.Supplier;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.InjectGather;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.wrap.ParamWrap;
import org.noear.solon.lang.Nullable;

public class VarHolderOfParam
implements VarHolder {
    private final ParamWrap pw;
    private final AppContext ctx;
    private Class<?> dependencyType;
    private Object val;
    private Supplier valDef;
    private boolean done;
    private boolean required = false;
    private InjectGather gather;

    public VarHolderOfParam(AppContext ctx, ParamWrap pw, InjectGather gather) {
        this.ctx = ctx;
        this.pw = pw;
        this.gather = gather;
    }

    @Override
    public AppContext context() {
        return this.ctx;
    }

    @Override
    public boolean isField() {
        return false;
    }

    @Override
    public Class<?> getDependencyType() {
        if (this.dependencyType == null) {
            return this.getType();
        }
        return this.dependencyType;
    }

    @Override
    public void setDependencyType(Class<?> dependencyType) {
        this.dependencyType = dependencyType;
    }

    @Override
    public Class<?> getType() {
        return this.pw.getType();
    }

    @Override
    @Nullable
    public ParameterizedType getGenericType() {
        return this.pw.getGenericType();
    }

    @Override
    public Annotation[] getAnnoS() {
        return this.pw.getParameter().getAnnotations();
    }

    @Override
    public String getFullName() {
        Class<?> declClz;
        Executable e = this.pw.getParameter().getDeclaringExecutable();
        Class<?> fileClz = declClz = e.getDeclaringClass();
        if (declClz.isMemberClass()) {
            fileClz = declClz.getEnclosingClass();
        }
        if (e instanceof Method) {
            Method m = (Method)e;
            return "'" + this.pw.getParameter().getName() + "'\r\n\tat " + declClz.getName() + "." + m.getName() + "(" + fileClz.getSimpleName() + ".java:0)";
        }
        return "'" + this.pw.getParameter().getName() + "'\r\n\tat " + declClz.getName() + "(" + fileClz.getSimpleName() + ".java:10)";
    }

    @Override
    public void setValue(Object val) {
        this.val = val;
        this.done = true;
        if (this.gather != null) {
            this.gather.run();
        }
    }

    @Override
    public void setValueDefault(Supplier supplier) {
        this.valDef = supplier;
    }

    @Override
    public Object getValue() {
        if (this.val == null && this.valDef != null) {
            return this.valDef.get();
        }
        return this.val;
    }

    @Override
    public void commit() {
        Object tmp;
        if (this.isDone()) {
            return;
        }
        if (this.valDef != null && (tmp = this.valDef.get()) != null) {
            this.setValue(tmp);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public void required(boolean required) {
        this.required = required;
    }

    public String toString() {
        if (this.pw.getGenericType() == null) {
            return this.pw.getName() + ":" + this.pw.getType().getTypeName();
        }
        return this.pw.getName() + ":" + this.pw.getGenericType().getTypeName();
    }
}

