/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.wrap;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.runtime.NativeDetector;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.ReflectUtil;
import org.noear.solon.core.wrap.ConstructorWrap;
import org.noear.solon.core.wrap.FieldWrap;
import org.noear.solon.core.wrap.ParamWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassWrap {
    static final Logger log = LoggerFactory.getLogger(ClassWrap.class);
    private static Map<Class<?>, ClassWrap> cached = new ConcurrentHashMap();
    private final Class<?> _clz;
    private final Method[] declaredMethods;
    private final Method[] methods;
    private final List<FieldWrap> declaredFieldWraps;
    private final Map<String, FieldWrap> allFieldWrapMap;
    private final Map<String, FieldWrap> staticFieldWrapMap;
    private boolean _recordable;
    private ConstructorWrap _recordConstructorWrap;
    private List<Method> publicMethods;

    public static ClassWrap get(Class<?> clz) {
        ClassWrap cw = cached.get(clz);
        if (cw == null) {
            Utils.locker().lock();
            try {
                cw = cached.get(clz);
                if (cw == null) {
                    cw = new ClassWrap(clz);
                    cached.put(clz, cw);
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException("ClassWrap build failed: " + clz.getName(), ex);
            }
            finally {
                Utils.locker().unlock();
            }
        }
        return cw;
    }

    protected ClassWrap(Class<?> clz) {
        this._clz = clz;
        this._recordable = true;
        this.declaredMethods = this.getDeclaredMethods(clz);
        this.methods = this.getMethods(clz);
        this.declaredFieldWraps = new ArrayList<FieldWrap>();
        this.allFieldWrapMap = new LinkedHashMap<String, FieldWrap>();
        this.staticFieldWrapMap = new LinkedHashMap<String, FieldWrap>();
        this.doScanAllFields(clz);
        for (Field f : ReflectUtil.getDeclaredFields(clz)) {
            FieldWrap fw = this.allFieldWrapMap.get(f.getName());
            if (fw == null) continue;
            this.declaredFieldWraps.add(fw);
        }
        if (this.declaredFieldWraps.size() == 0) {
            this._recordable = false;
        }
        if (this._recordable) {
            Constructor<?>[] tmp = clz.getDeclaredConstructors();
            this._recordConstructorWrap = new ConstructorWrap(clz, tmp[tmp.length - 1]);
        }
    }

    private Method[] getDeclaredMethods(Class<?> clz) {
        ArrayList<Method> tmp = new ArrayList<Method>();
        for (Method m1 : ReflectUtil.getDeclaredMethods(clz)) {
            if (m1.isBridge()) continue;
            tmp.add(m1);
        }
        return tmp.toArray(new Method[tmp.size()]);
    }

    private Method[] getMethods(Class<?> clz) {
        ArrayList<Method> tmp = new ArrayList<Method>();
        for (Method m1 : ReflectUtil.getMethods(clz)) {
            if (!m1.isBridge()) {
                tmp.add(m1);
                continue;
            }
            m1 = this.getRealMethod(clz.getSuperclass(), m1);
            if (m1 == null || m1.isBridge()) continue;
            tmp.add(m1);
        }
        return tmp.toArray(new Method[tmp.size()]);
    }

    private Method getRealMethod(Class<?> clz, Method m1) {
        try {
            m1 = clz.getMethod(m1.getName(), m1.getParameterTypes());
            if (m1 != null) {
                if (m1.isBridge()) {
                    return this.getRealMethod(clz.getSuperclass(), m1);
                }
                return m1;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Class<?> clz() {
        return this._clz;
    }

    public Collection<FieldWrap> getAllFieldWraps() {
        return this.allFieldWrapMap.values();
    }

    public Collection<FieldWrap> getStaticFieldWraps() {
        return this.staticFieldWrapMap.values();
    }

    public FieldWrap getFieldWrap(String field) {
        return this.allFieldWrapMap.get(field);
    }

    public Method[] getDeclaredMethods() {
        return this.declaredMethods;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public Collection<Method> findPublicMethods() {
        if (this.publicMethods == null) {
            this.publicMethods = new ArrayList<Method>();
            for (Method m1 : this.getDeclaredMethods()) {
                if (Modifier.isPublic(m1.getModifiers())) continue;
                this.publicMethods.add(m1);
            }
            for (Method m1 : this.getMethods()) {
                this.publicMethods.add(m1);
            }
        }
        return this.publicMethods;
    }

    public Method findPublicMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        String internedName = name.intern();
        for (Method m1 : this.getDeclaredMethods()) {
            if (m1.getParameterCount() != parameterTypes.length || m1.getName() != internedName) continue;
            if (parameterTypes.length == 0) {
                return m1;
            }
            if (!Arrays.equals(m1.getParameterTypes(), parameterTypes)) continue;
            return m1;
        }
        for (Method m1 : this.getMethods()) {
            if (m1.getParameterCount() != parameterTypes.length || m1.getName() != internedName) continue;
            if (parameterTypes.length == 0) {
                return m1;
            }
            if (!Arrays.equals(m1.getParameterTypes(), parameterTypes)) continue;
            return m1;
        }
        throw new NoSuchMethodException(this._clz.getName() + "." + name + ClassWrap.argumentTypesToString(parameterTypes));
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public <T> T newBy(Properties data) {
        try {
            Constructor<?> constructor = this.clz().getConstructor(Properties.class);
            if (constructor != null) {
                return (T)constructor.newInstance(data);
            }
        }
        catch (Throwable throwable) {
        }
        return this.newBy(data::getProperty);
    }

    public <T> T newBy(Function<String, String> data) {
        try {
            return this.newBy(data, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T> T newBy(Function<String, String> data, Context ctx) throws Exception {
        if (this._recordable) {
            ParamWrap[] argsP = this._recordConstructorWrap.getParamWraps();
            Object[] argsV = new Object[argsP.length];
            for (int i = 0; i < argsP.length; ++i) {
                Object val;
                ParamWrap p = argsP[i];
                String key = p.spec().getName();
                String val0 = data.apply(key);
                argsV[i] = val0 != null ? (val = ConvertUtil.to(p.spec(), val0, ctx)) : (p.getType() == UploadedFile.class ? ctx.file(key) : null);
            }
            Object obj = this._recordConstructorWrap.getConstructor().newInstance(argsV);
            return obj;
        }
        Object obj = ClassUtil.newInstance(this.clz());
        this.doFill(obj, data, ctx);
        return obj;
    }

    public void fill(Object bean, Function<String, String> data) {
        try {
            this.doFill(bean, data, null);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void doFill(Object bean, Function<String, String> data, Context ctx) throws Exception {
        if (this.allFieldWrapMap.isEmpty() && NativeDetector.inNativeImage()) {
            log.warn(String.format("Class: %s don't have any field, can't fill data. you should use: nativeMetadata.registerField(field) at aot runtime.", this._clz.getName()));
        }
        for (Map.Entry<String, FieldWrap> kv : this.allFieldWrapMap.entrySet()) {
            UploadedFile[] files1;
            String key = kv.getKey();
            String val0 = data.apply(key);
            FieldWrap fw = kv.getValue();
            if (val0 != null) {
                Object val = ConvertUtil.to(fw.spec(), val0, ctx);
                fw.setValue(bean, val);
                continue;
            }
            if (ctx == null) continue;
            if (fw.getType() == UploadedFile.class) {
                UploadedFile file1 = ctx.file(key);
                if (file1 == null) continue;
                fw.setValue(bean, file1);
                continue;
            }
            if (fw.getType() != UploadedFile[].class || (files1 = ctx.fileValues(key)) == null) continue;
            fw.setValue(bean, files1);
        }
    }

    private void doScanAllFields(Class<?> clz) {
        if (clz == null) {
            return;
        }
        for (Field f : ReflectUtil.getDeclaredFields(clz)) {
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod)) {
                if (this.allFieldWrapMap.containsKey(f.getName())) continue;
                this._recordable &= Modifier.isFinal(mod);
                this.allFieldWrapMap.put(f.getName(), new FieldWrap(this._clz, f));
                continue;
            }
            this.staticFieldWrapMap.put(f.getName(), new FieldWrap(this._clz, f));
        }
        Class<?> sup = clz.getSuperclass();
        if (sup != Object.class) {
            this.doScanAllFields(sup);
        }
    }
}

